/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.ui;

import com.intuit.karate.ui.App;
import com.intuit.karate.ui.AppSession;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;

public class HeaderPanel
extends BorderPane {
    private final HBox content;
    private final AppSession session;
    private final MenuItem openFileMenuItem;
    private final MenuItem openImportMenuItem;
    private final TextArea textContent;
    private String oldText;

    public HeaderPanel() {
        this(null);
    }

    public HeaderPanel(AppSession session) {
        this.session = session;
        this.content = new HBox(5.0);
        this.content.setPadding(new Insets(5.0));
        this.setCenter((Node)this.content);
        this.textContent = new TextArea();
        this.textContent.setPrefRowCount(16);
        this.textContent.setVisible(false);
        this.setBottom((Node)this.textContent);
        this.textContent.setManaged(false);
        this.textContent.setFont(App.DEFAULT_FONT);
        this.textContent.focusedProperty().addListener((val, before, after) -> {
            if (!after.booleanValue()) {
                this.rebuildFeatureIfTextChanged();
            }
        });
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = new Menu("File");
        this.openFileMenuItem = new MenuItem("Open");
        fileMenu.getItems().addAll((Object[])new MenuItem[]{this.openFileMenuItem});
        Menu importMenu = new Menu("Import");
        this.openImportMenuItem = new MenuItem("Open");
        importMenu.getItems().addAll((Object[])new MenuItem[]{this.openImportMenuItem});
        menuBar.getMenus().addAll((Object[])new Menu[]{fileMenu, importMenu});
        this.setTop((Node)menuBar);
        if (session != null) {
            Label envLabel = new Label("karate.env");
            envLabel.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
            TextField envTextField = new TextField();
            envTextField.setText(session.getEnv().env);
            Button envButton = new Button("Reset");
            envButton.setOnAction(e -> session.resetAll(envTextField.getText()));
            Button runAllButton = new Button("Run \u25ba\u25ba");
            runAllButton.setOnAction(e -> session.runAll());
            Button showContentButton = new Button(this.getContentButtonText(false));
            this.initTextContent();
            showContentButton.setOnAction(e -> {
                boolean visible = !this.textContent.isVisible();
                this.textContent.setVisible(visible);
                this.textContent.setManaged(visible);
                showContentButton.setText(this.getContentButtonText(visible));
            });
            this.content.getChildren().addAll((Object[])new Node[]{envLabel, envTextField, envButton, runAllButton, showContentButton});
        }
    }

    private String getContentButtonText(boolean visible) {
        return visible ? "Hide Raw" : "Show Raw";
    }

    public void setFileOpenAction(EventHandler<ActionEvent> handler) {
        this.openFileMenuItem.setOnAction(handler);
    }

    public void setImportOpenAction(EventHandler<ActionEvent> handler) {
        this.openImportMenuItem.setOnAction(handler);
    }

    public void initTextContent() {
        this.oldText = this.session.getFeature().getText();
        this.textContent.setText(this.oldText);
    }

    public void rebuildFeatureIfTextChanged() {
        String newText = this.textContent.getText();
        if (!newText.equals(this.oldText)) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setHeaderText("Read Only");
            alert.setTitle("Not Implemented");
            alert.setContentText("Raw text editing is not supported.");
            alert.show();
            this.textContent.setText(this.oldText);
        }
    }
}

