/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class HttpBody {
    private final byte[] bytes;
    private final InputStream stream;
    private final MultiValuedMap fields;
    private final List<MultiPartItem> parts;
    private final String contentType;

    public boolean isStream() {
        return this.stream != null;
    }

    public boolean isUrlEncoded() {
        return this.fields != null;
    }

    public boolean isMultiPart() {
        return this.parts != null;
    }

    public byte[] getBytes() {
        if (this.isStream()) {
            try {
                return IOUtils.toByteArray((InputStream)this.stream);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.bytes;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public List<MultiPartItem> getParts() {
        return this.parts;
    }

    public Map<String, String[]> getParameters() {
        if (this.fields == null) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>(this.fields.size());
        for (Map.Entry entry : this.fields.entrySet()) {
            List list = (List)entry.getValue();
            String[] values = new String[list.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = list.get(i) + "";
            }
            map.put((String)entry.getKey(), values);
        }
        return map;
    }

    private HttpBody(byte[] bytes, InputStream stream, String contentType) {
        this.bytes = bytes;
        this.stream = stream;
        this.contentType = contentType;
        this.fields = null;
        this.parts = null;
    }

    private HttpBody(MultiValuedMap fields, String contentType) {
        this.bytes = null;
        this.stream = null;
        this.contentType = contentType;
        this.fields = fields;
        this.parts = null;
    }

    private HttpBody(List<MultiPartItem> parts, String contentType) {
        this.bytes = null;
        this.stream = null;
        this.contentType = contentType;
        this.fields = null;
        this.parts = parts;
    }

    public static HttpBody string(String value, String contentType) {
        return new HttpBody(value.getBytes(), null, contentType);
    }

    public static HttpBody stream(InputStream stream, String contentType) {
        return new HttpBody(null, stream, contentType);
    }

    public static HttpBody bytes(byte[] bytes, String contentType) {
        return new HttpBody(bytes, null, contentType);
    }

    public static HttpBody formFields(MultiValuedMap fields, String contentType) {
        return new HttpBody(fields, contentType);
    }

    public static HttpBody multiPart(List<MultiPartItem> parts, String contentType) {
        return new HttpBody(parts, contentType);
    }
}

