/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.ScriptEnv;
import com.intuit.karate.cucumber.CucumberUtils;
import com.intuit.karate.cucumber.FeatureSection;
import com.intuit.karate.cucumber.ScenarioOutlineWrapper;
import com.intuit.karate.cucumber.ScenarioWrapper;
import com.intuit.karate.cucumber.StepWrapper;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.CucumberScenario;
import cucumber.runtime.model.CucumberScenarioOutline;
import cucumber.runtime.model.CucumberTagStatement;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FeatureWrapper {
    private final String path;
    private final String text;
    private final List<String> lines;
    private final CucumberFeature feature;
    private final List<FeatureSection> featureSections;
    private ScriptEnv scriptEnv;

    public ScriptEnv getEnv() {
        return this.scriptEnv;
    }

    public void setEnv(ScriptEnv scriptEnv) {
        this.scriptEnv = scriptEnv;
    }

    public static FeatureWrapper fromFile(File file, ClassLoader classLoader) {
        try {
            String text = FileUtils.readFileToString((File)file, (String)"utf-8");
            ScriptEnv env = ScriptEnv.init(file.getParentFile(), file.getName(), classLoader);
            return new FeatureWrapper(text, env, file.getPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FeatureWrapper fromFile(File file, ScriptEnv env) {
        try {
            String text = FileUtils.readFileToString((File)file, (String)"utf-8");
            return new FeatureWrapper(text, env, file.getPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FeatureWrapper fromString(String text, ScriptEnv scriptEnv, String path) {
        return new FeatureWrapper(text, scriptEnv, path);
    }

    public static FeatureWrapper fromStream(InputStream is, ScriptEnv scriptEnv, String path) {
        try {
            String text = IOUtils.toString((InputStream)is, (String)"utf-8");
            return new FeatureWrapper(text, scriptEnv, path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String joinLines(int startLine, int endLine) {
        StringBuilder sb = new StringBuilder();
        for (int i = startLine; i < endLine; ++i) {
            String line = this.lines.get(i);
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    public String joinLines() {
        int lineCount = this.lines.size();
        return this.joinLines(0, lineCount);
    }

    public List<String> getLines() {
        return this.lines;
    }

    public CucumberFeature getFeature() {
        return this.feature;
    }

    public List<FeatureSection> getSections() {
        return this.featureSections;
    }

    public String getPath() {
        return this.path;
    }

    public String getText() {
        return this.text;
    }

    public FeatureWrapper addLine(int index, String line) {
        this.lines.add(index, line);
        return new FeatureWrapper(this.joinLines(), this.scriptEnv, this.path);
    }

    public FeatureSection getSection(int sectionIndex) {
        return this.featureSections.get(sectionIndex);
    }

    public ScenarioWrapper getScenario(int sectionIndex, int scenarioIndex) {
        FeatureSection section = this.getSection(sectionIndex);
        if (scenarioIndex == -1) {
            return section.getScenario();
        }
        ScenarioOutlineWrapper outline = section.getScenarioOutline();
        return outline.getScenarios().get(scenarioIndex);
    }

    public StepWrapper getStep(int sectionIndex, int scenarioIndex, int stepIndex) {
        ScenarioWrapper scenario = this.getScenario(sectionIndex, scenarioIndex);
        return scenario.getSteps().get(stepIndex);
    }

    public FeatureWrapper replaceStep(StepWrapper step, String text) {
        return this.replaceLines(step.getStartLine(), step.getEndLine(), text);
    }

    public FeatureWrapper replaceLines(int start, int end, String text) {
        for (int i = start; i < end; ++i) {
            this.lines.remove(start);
        }
        this.lines.set(start, text);
        return new FeatureWrapper(this.joinLines(), this.scriptEnv, this.path);
    }

    public FeatureWrapper removeLine(int index) {
        this.lines.remove(index);
        return new FeatureWrapper(this.joinLines(), this.scriptEnv, this.path);
    }

    private FeatureWrapper(String text, ScriptEnv scriptEnv, String path) {
        this.path = path;
        this.text = text;
        this.scriptEnv = scriptEnv;
        this.feature = CucumberUtils.parse(text);
        try {
            InputStream is = IOUtils.toInputStream((String)text, (String)"utf-8");
            this.lines = IOUtils.readLines((InputStream)is, (String)"utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.featureSections = new ArrayList<FeatureSection>();
        List elements = this.feature.getFeatureElements();
        int count = elements.size();
        for (int i = 0; i < count; ++i) {
            FeatureSection section;
            CucumberTagStatement cts = (CucumberTagStatement)elements.get(i);
            if (cts instanceof CucumberScenario) {
                CucumberScenario sw = (CucumberScenario)cts;
                ScenarioWrapper scenario = new ScenarioWrapper(this, -1, sw, null);
                section = new FeatureSection(i, this, scenario, null);
                this.featureSections.add(section);
                continue;
            }
            if (cts instanceof CucumberScenarioOutline) {
                CucumberScenarioOutline cso = (CucumberScenarioOutline)cts;
                ScenarioOutlineWrapper scenarioOutline = new ScenarioOutlineWrapper(this, cso);
                section = new FeatureSection(i, this, null, scenarioOutline);
                this.featureSections.add(section);
                continue;
            }
            throw new RuntimeException("unexpected type: " + cts.getClass());
        }
    }
}

