/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.convert;

import com.intuit.karate.convert.PostmanCollectionReader;
import com.intuit.karate.convert.PostmanRequest;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarateFeatureWriter {
    private static final Logger logger = LoggerFactory.getLogger(PostmanCollectionReader.class);

    private KarateFeatureWriter() {
    }

    public static File write(List<PostmanRequest> requests, String path) {
        String feature = KarateFeatureWriter.getFeature(requests);
        String inputFileName = new File(path).getName();
        String outputFileName = inputFileName.replace("postman_collection", "feature");
        String dirPath = new File(path).getParentFile().getPath();
        try {
            File featureFile = new File(dirPath + "/" + outputFileName);
            FileUtils.writeStringToFile((File)featureFile, (String)feature, (String)"utf-8");
            return featureFile;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFeature(List<PostmanRequest> requests) {
        String scenarios = "";
        for (PostmanRequest request : requests) {
            scenarios = scenarios + request.convert();
        }
        String feature = "Feature: \n\n" + scenarios;
        return feature;
    }
}

