/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptContext;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.cucumber.FeatureWrapper;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ClassUtils;
import org.w3c.dom.Node;

public class ScriptValue {
    public static final ScriptValue NULL = new ScriptValue(null);
    private final Object value;
    private final Type type;
    private final String source;

    public Object getValue() {
        return this.value;
    }

    public String getTypeAsShortString() {
        switch (this.type) {
            case NULL: {
                return "null";
            }
            case UNKNOWN: {
                return "?";
            }
            case PRIMITIVE: {
                return "num";
            }
            case STRING: {
                return "str";
            }
            case MAP: {
                return "map";
            }
            case LIST: {
                return "list";
            }
            case JSON: {
                return "json";
            }
            case XML: {
                return "xml";
            }
            case JS_ARRAY: {
                return "js[]";
            }
            case JS_OBJECT: {
                return "js{}";
            }
            case JS_FUNCTION: {
                return "js()";
            }
            case INPUT_STREAM: {
                return "stream";
            }
            case FEATURE_WRAPPER: {
                return "feat";
            }
        }
        return "??";
    }

    public boolean isNull() {
        return this.type == Type.NULL;
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isStream() {
        return this.type == Type.INPUT_STREAM;
    }

    public boolean isUnknownType() {
        return this.type == Type.UNKNOWN;
    }

    public boolean isBooleanTrue() {
        return this.type == Type.PRIMITIVE && "true".equals(this.value.toString());
    }

    public boolean isListLike() {
        switch (this.type) {
            case LIST: 
            case JS_ARRAY: {
                return true;
            }
        }
        return false;
    }

    public List getAsList() {
        switch (this.type) {
            case JS_ARRAY: {
                Collection coll = this.getValue(ScriptObjectMirror.class).values();
                return new ArrayList(coll);
            }
            case LIST: {
                return this.getValue(List.class);
            }
        }
        throw new RuntimeException("cannot convert to list: " + this);
    }

    public boolean isMapLike() {
        switch (this.type) {
            case MAP: 
            case JSON: 
            case XML: 
            case JS_OBJECT: {
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAsMap() {
        switch (this.type) {
            case MAP: 
            case JS_OBJECT: {
                return this.getValue(Map.class);
            }
            case JSON: {
                DocumentContext json = this.getValue(DocumentContext.class);
                return (Map)json.read("$", new Predicate[0]);
            }
            case XML: {
                Node xml = this.getValue(Node.class);
                return (Map)XmlUtils.toObject(xml);
            }
        }
        throw new RuntimeException("cannot convert to map: " + this);
    }

    public Map<String, Object> evalAsMap(ScriptContext context) {
        if (this.type == Type.JS_FUNCTION) {
            ScriptObjectMirror som = this.getValue(ScriptObjectMirror.class);
            ScriptValue sv = Script.evalFunctionCall(som, null, context);
            return sv.isMapLike() ? sv.getAsMap() : null;
        }
        return this.isMapLike() ? this.getAsMap() : null;
    }

    public String getAsPrettyString() {
        switch (this.type) {
            case NULL: {
                return "";
            }
            case XML: {
                Node node = this.getValue(Node.class);
                return XmlUtils.toString(node, true);
            }
            case JSON: {
                DocumentContext doc = this.getValue(DocumentContext.class);
                return JsonUtils.toPrettyJsonString(doc);
            }
            case LIST: 
            case JS_ARRAY: {
                List list = this.getAsList();
                DocumentContext listDoc = JsonPath.parse((Object)list);
                return JsonUtils.toPrettyJsonString(listDoc);
            }
            case MAP: 
            case JS_OBJECT: {
                Map<String, Object> map = this.getAsMap();
                DocumentContext mapDoc = JsonPath.parse(map);
                return JsonUtils.toPrettyJsonString(mapDoc);
            }
            case INPUT_STREAM: {
                return "(..stream..)";
            }
        }
        return this.value.toString();
    }

    public String getAsString() {
        switch (this.type) {
            case NULL: {
                return null;
            }
            case JSON: {
                DocumentContext doc = this.getValue(DocumentContext.class);
                return doc.jsonString();
            }
            case XML: {
                Node node = this.getValue(Node.class);
                if (node.getTextContent() != null) {
                    return node.getTextContent();
                }
                return XmlUtils.toString(node);
            }
            case LIST: 
            case JS_ARRAY: {
                List list = this.getAsList();
                DocumentContext listDoc = JsonPath.parse((Object)list);
                return listDoc.jsonString();
            }
            case MAP: 
            case JS_OBJECT: {
                Map<String, Object> map = this.getAsMap();
                DocumentContext mapDoc = JsonPath.parse(map);
                return mapDoc.jsonString();
            }
            case JS_FUNCTION: {
                return this.value.toString().replace("\n", " ");
            }
            case INPUT_STREAM: {
                try {
                    return IOUtils.toString((InputStream)this.getValue(InputStream.class), (String)"utf-8");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.value.toString();
    }

    public InputStream getAsStream() {
        switch (this.type) {
            case NULL: {
                return null;
            }
            case INPUT_STREAM: {
                return this.getValue(InputStream.class);
            }
        }
        return new ByteArrayInputStream(this.getAsString().getBytes());
    }

    public Object getAfterConvertingFromJsonOrXmlIfNeeded() {
        switch (this.type) {
            case JSON: {
                DocumentContext json = this.getValue(DocumentContext.class);
                return json.read("$", new Predicate[0]);
            }
            case XML: {
                Node xml = this.getValue(Node.class);
                return XmlUtils.toObject(xml);
            }
        }
        return this.getValue();
    }

    public Type getType() {
        return this.type;
    }

    public <T> T getValue(Class<T> clazz) {
        if (this.value == null) {
            return null;
        }
        return (T)this.value;
    }

    public ScriptValue(Object value) {
        this(value, null);
    }

    public ScriptValue(Object value, String source) {
        ScriptObjectMirror som;
        this.value = value;
        this.source = source;
        this.type = value == null ? Type.NULL : (value instanceof DocumentContext ? Type.JSON : (value instanceof Node ? Type.XML : (value instanceof List ? Type.LIST : (value instanceof Map ? (value instanceof ScriptObjectMirror ? ((som = (ScriptObjectMirror)value).isArray() ? Type.JS_ARRAY : (som.isFunction() ? Type.JS_FUNCTION : Type.JS_OBJECT)) : Type.MAP) : (value instanceof String ? Type.STRING : (value instanceof InputStream ? Type.INPUT_STREAM : (ClassUtils.isPrimitiveOrWrapper(value.getClass()) ? Type.PRIMITIVE : (value instanceof FeatureWrapper ? Type.FEATURE_WRAPPER : Type.UNKNOWN))))))));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[type: ").append((Object)this.type);
        sb.append(", value: ").append(this.value);
        if (this.source != null) {
            sb.append(", source: ").append(this.source);
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum Type {
        NULL,
        UNKNOWN,
        PRIMITIVE,
        STRING,
        MAP,
        LIST,
        JSON,
        XML,
        JS_ARRAY,
        JS_OBJECT,
        JS_FUNCTION,
        INPUT_STREAM,
        FEATURE_WRAPPER;

    }
}

