/*
 * Decompiled with CFR 0.152.
 */
package com.intrusoft.blaze;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import com.intrusoft.blaze.BitmapResolver;
import com.intrusoft.blaze.R;

public class ZoomView
extends View {
    Bitmap imageSrc;
    float x1;
    float y1;
    float x2;
    float y2;
    int HEIGHT;
    int WIDTH;
    int MAX_ZOOM;
    RectF rect1;
    RectF rect2;
    Handler handler;
    Paint paint;
    Integer integer;
    Context context;
    float changeFactor = 0.5f;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            ZoomView.this.updateValues();
        }
    };

    public ZoomView(Context context) {
        super(context);
        this.context = context;
    }

    public ZoomView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ZoomView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Context context, AttributeSet attrs) {
        this.context = context;
        TypedArray typeArray = context.obtainStyledAttributes(attrs, R.styleable.ZoomView, 0, 0);
        try {
            this.integer = typeArray.getResourceId(R.styleable.ZoomView_src, R.drawable.place_holder);
            this.changeFactor = typeArray.getFloat(R.styleable.ZoomView_translation_factor, 0.5f);
        }
        finally {
            typeArray.recycle();
        }
        this.resetValues();
    }

    protected void onDraw(Canvas canvas) {
        if (this.HEIGHT > 0) {
            if (this.imageSrc != null) {
                this.rect1.set(0.0f, 0.0f, (float)this.WIDTH, (float)this.HEIGHT);
                this.rect2.set(this.x1, this.y1, this.x2, this.y2);
                if (this.rect1.intersect(this.rect2)) {
                    canvas.drawBitmap(this.imageSrc, null, this.rect2, this.paint);
                }
            }
        } else {
            this.resetValues();
        }
        super.onDraw(canvas);
        this.handler.postDelayed(this.runnable, 16L);
    }

    private void updateValues() {
        if (this.y2 - this.y1 > (float)this.MAX_ZOOM || this.y2 - this.y1 < (float)this.HEIGHT) {
            this.changeFactor = -this.changeFactor;
        }
        this.x1 -= this.changeFactor;
        this.x2 += this.changeFactor;
        this.y1 -= this.changeFactor;
        this.y2 += this.changeFactor;
        this.invalidate();
    }

    private void resetValues() {
        this.WIDTH = this.getWidth();
        this.HEIGHT = this.getHeight();
        this.MAX_ZOOM = (int)((float)this.HEIGHT * 6.0f);
        this.rect1 = new RectF();
        this.rect2 = new RectF();
        this.paint = new Paint();
        this.x1 = 0.0f;
        this.x2 = this.WIDTH;
        this.y1 = 0.0f;
        this.y2 = this.HEIGHT;
        this.handler = new Handler();
        this.setImageResource(this.integer);
    }

    public void setTranslationFactor(float factor) {
        this.changeFactor = factor;
    }

    public void setImageResource(Integer resId) {
        BitmapResolver.getBitmap(this.context, resId, this.WIDTH, this.HEIGHT, new BitmapResolver.FinalBitmap(){

            @Override
            public void getBitmap(Bitmap bitmap) {
                ZoomView.this.imageSrc = bitmap;
            }
        });
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.imageSrc = bitmap;
    }
}

