/*
 * Decompiled with CFR 0.152.
 */
package com.intrusoft.blaze;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import com.intrusoft.blaze.BitmapResolver;
import com.intrusoft.blaze.R;

public class MotionView
extends View {
    Bitmap imageSrc;
    int x1;
    int y;
    int x2;
    int HEIGHT;
    int WIDTH;
    int CHANGE;
    Rect rect1;
    Rect rect2;
    Rect layerRect;
    Handler handler;
    Paint paint;
    int moveFactor;
    Integer integer;
    Context context;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            MotionView.this.updateValues();
        }
    };

    public MotionView(Context context) {
        super(context);
        this.context = context;
    }

    public MotionView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MotionView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Context context, AttributeSet attrs) {
        this.context = context;
        TypedArray typeArray = context.obtainStyledAttributes(attrs, R.styleable.MotionView, 0, 0);
        try {
            this.integer = typeArray.getResourceId(R.styleable.MotionView_src, R.drawable.place_holder);
            this.moveFactor = (int)typeArray.getFloat(R.styleable.MotionView_translation_factor, 6.0f);
        }
        finally {
            typeArray.recycle();
        }
        this.resetValues();
    }

    protected void onDraw(Canvas canvas) {
        if (this.HEIGHT > 0) {
            if (this.imageSrc != null) {
                this.rect1.set(this.x1, 0, this.x1 + this.CHANGE, this.HEIGHT);
                this.rect2.set(this.x2, 0, this.x2 + this.CHANGE, this.HEIGHT);
                canvas.drawBitmap(this.imageSrc, null, this.rect1, this.paint);
                canvas.drawBitmap(this.imageSrc, null, this.rect2, this.paint);
            }
        } else {
            this.resetValues();
        }
        super.onDraw(canvas);
        this.handler.postDelayed(this.runnable, 16L);
    }

    public void updateValues() {
        if (this.x1 + this.CHANGE < 0) {
            this.x1 = this.CHANGE;
        }
        if (this.x2 + this.CHANGE < 0) {
            this.x2 = this.CHANGE;
        }
        this.x1 -= this.moveFactor;
        this.x2 -= this.moveFactor;
        this.invalidate();
    }

    public void resetValues() {
        this.WIDTH = this.getWidth();
        this.HEIGHT = this.getHeight();
        this.CHANGE = (int)((double)this.WIDTH * 1.5);
        this.rect1 = new Rect();
        this.rect2 = new Rect();
        this.layerRect = new Rect(0, 0, this.WIDTH, this.HEIGHT);
        this.paint = new Paint();
        this.x1 = 0;
        this.x2 = this.CHANGE;
        this.y = 0;
        this.handler = new Handler();
        this.setImageResource(this.integer);
    }

    public void setTranslationFactor(int factor) {
        this.moveFactor = factor;
    }

    public void setImageResource(Integer resId) {
        BitmapResolver.getBitmap(this.context, resId, this.WIDTH, this.HEIGHT, new BitmapResolver.FinalBitmap(){

            @Override
            public void getBitmap(Bitmap bitmap) {
                MotionView.this.imageSrc = bitmap;
            }
        });
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.imageSrc = bitmap;
    }
}

