/*
 * Decompiled with CFR 0.152.
 */
package com.intrusoft.blaze;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;

public class BitmapResolver {
    public static void getBitmap(final Context context, final Integer resId, final int height, final int width, final FinalBitmap finalBitmap) {
        new AsyncTask<Void, Void, Bitmap>(){

            protected Bitmap doInBackground(Void ... params) {
                return BitmapResolver.decodeSampledBitmapFromResource(context.getResources(), resId, width, height);
            }

            protected void onPostExecute(Bitmap bitmap) {
                super.onPostExecute((Object)bitmap);
                finalBitmap.getBitmap(bitmap);
            }
        }.execute((Object[])new Void[0]);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static Bitmap decodeSampledBitmapFromResource(Resources res, int resId, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapResolver.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
    }

    static interface FinalBitmap {
        public void getBitmap(Bitmap var1);
    }
}

