/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.maven.encoding;

import java.io.File;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.Native2Ascii;
import org.sonatype.plexus.build.incremental.BuildContext;

public class EncodingMojo
extends AbstractMojo {
    protected File src;
    protected String ext;
    protected String encoding;
    protected String includes;
    protected String excludes;
    protected MavenProject project;
    protected Resource resource;
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.src.exists()) {
            this.getLog().info((CharSequence)("Encoding: No resource directory '" + this.src.getPath() + "' found"));
            return;
        }
        this.getLog().info((CharSequence)("Encoding: Resource directory '" + this.src.getPath() + "' -> '" + this.resource.getDirectory() + "'"));
        this.executeAnt();
        this.project.addResource(this.resource);
    }

    protected void executeAnt() {
        Project antProject = new Project();
        antProject.setName("native2ascii");
        Native2Ascii antTask = new Native2Ascii();
        antTask.setProject(antProject);
        antTask.setSrc(this.src);
        File resourceDir = new File(this.resource.getDirectory());
        antTask.setDest(resourceDir);
        antTask.setEncoding(this.encoding);
        antTask.setExt(this.ext);
        antTask.setExcludes(this.excludes);
        antTask.setIncludes(this.includes);
        antTask.execute();
    }
}

