/*
 * Decompiled with CFR 0.152.
 */
package com.intershop.release.version;

import com.intershop.release.version.MetadataVersion;
import com.intershop.release.version.NormalVersion;
import com.intershop.release.version.ParserException;
import com.intershop.release.version.Version;
import com.intershop.release.version.VersionExtension;
import com.intershop.release.version.VersionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class VersionParser {
    private final String input;

    public VersionParser(String input) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("Input string is NULL or empty");
        }
        this.input = input;
    }

    public Version getVersion() {
        return this.getVersion(VersionType.threeDigits);
    }

    public Version getVersion(VersionType type) {
        if (this.input == null || this.input.isEmpty()) {
            throw new IllegalArgumentException("Input string is NULL or empty");
        }
        return VersionParser.parseVersion(this.input, type);
    }

    public static Version parseVersion(String inputStr) {
        return VersionParser.parseVersion(inputStr, VersionType.threeDigits);
    }

    public static Version parseVersion(String inputStr, @Nonnull VersionType type) {
        Pattern versionMatcher;
        String metadata;
        String[] parsedVersions = new String[3];
        int i = inputStr.indexOf(45);
        String v = i > 0 ? inputStr.substring(0, i) : inputStr;
        String string = metadata = i > 0 ? inputStr.substring(i + 1) : "";
        if (Pattern.compile("^\\d+\\.\\d+\\.\\d+\\.\\d+").matcher(v).matches()) {
            type = VersionType.fourDigits;
        }
        Pattern pattern = versionMatcher = type == VersionType.threeDigits ? Pattern.compile("^\\d+\\.?\\d*\\.?\\d*$") : Pattern.compile("^\\d+\\.?\\d*\\.?\\d*\\.?\\d*$");
        if (!versionMatcher.matcher(v).matches()) {
            throw new ParserException("No valid version found in " + inputStr + "!");
        }
        parsedVersions[0] = v;
        parsedVersions[1] = "";
        parsedVersions[2] = "";
        VersionExtension extension = VersionExtension.NONE;
        if (!metadata.isEmpty()) {
            String testStr = metadata.toLowerCase();
            String metadataStr = metadata;
            if (testStr.endsWith("snapshot")) {
                if (testStr.equals("snapshot")) {
                    extension = VersionExtension.SNAPSHOT;
                    metadataStr = "";
                } else if (testStr.endsWith("-snapshot")) {
                    extension = VersionExtension.SNAPSHOT;
                    metadataStr = metadata.substring(0, metadata.length() - "-snapshot".length());
                }
            } else if (testStr.endsWith("local")) {
                if (testStr.equals("local")) {
                    extension = VersionExtension.LOCAL;
                    metadataStr = "";
                } else if (testStr.endsWith("-local")) {
                    extension = VersionExtension.LOCAL;
                    metadataStr = metadata.substring(0, metadata.length() - "-local".length());
                }
            }
            if (!metadataStr.isEmpty()) {
                Matcher buildInfoGroup = Pattern.compile("([A-Za-z]+\\.?[\\d]+$)").matcher(metadataStr);
                if (buildInfoGroup.find()) {
                    parsedVersions[2] = buildInfoGroup.group(1);
                    String removeTail = buildInfoGroup.replaceAll("");
                    if (removeTail != null && !removeTail.isEmpty()) {
                        parsedVersions[1] = metadataStr.replace("-" + parsedVersions[2], "");
                    }
                } else {
                    parsedVersions[1] = metadataStr;
                }
            }
        }
        return new Version(VersionParser.parseNormalVersion(parsedVersions[0], type), VersionParser.parseBranchData(parsedVersions[1]), VersionParser.parseBuildData(parsedVersions[2]), extension, inputStr);
    }

    public static NormalVersion parseNormalVersion(String versionStr, VersionType type) {
        int start;
        ArrayList<String> vnumbers = new ArrayList<String>(Arrays.asList(versionStr.split("\\.")));
        for (int i = start = Math.min(4, vnumbers.size()); i <= 4; ++i) {
            vnumbers.add("0");
        }
        if (type == VersionType.fourDigits) {
            return new NormalVersion(VersionParser.parseDigit(vnumbers.get(0), versionStr), VersionParser.parseDigit(vnumbers.get(1), versionStr), VersionParser.parseDigit(vnumbers.get(2), versionStr), VersionParser.parseDigit(vnumbers.get(3), versionStr));
        }
        return new NormalVersion(VersionParser.parseDigit(vnumbers.get(0), versionStr), VersionParser.parseDigit(vnumbers.get(1), versionStr), VersionParser.parseDigit(vnumbers.get(2), versionStr));
    }

    public static MetadataVersion parseBranchData(String branchData) {
        return VersionParser.parseMetadataVersion(branchData);
    }

    public static MetadataVersion parseBuildData(String buildData) {
        return VersionParser.parseMetadataVersion(buildData);
    }

    public static VersionExtension parseVersionExtension(String extension) {
        return VersionExtension.valueOf(extension);
    }

    public static MetadataVersion parseMetadataVersion(String metadataInput) {
        MetadataVersion mdVersion = MetadataVersion.NULL;
        if (metadataInput != null && !metadataInput.isEmpty()) {
            ArrayList<String> identifiers = new ArrayList<String>();
            Matcher metadataMatcher = Pattern.compile("^(?<name>[A-Za-z]+\\.?)(?<number>[\\d]+)$").matcher(metadataInput);
            if (metadataMatcher.matches()) {
                identifiers.add(metadataMatcher.group("name"));
                int identNo = VersionParser.parseDigit(metadataMatcher.group("number"), metadataInput);
                identifiers.add(Integer.toString(identNo));
            } else {
                identifiers.add(metadataInput);
            }
            if (identifiers.size() > 0) {
                return new MetadataVersion(identifiers.toArray(new String[0]));
            }
        }
        return mdVersion;
    }

    private static int parseDigit(String digit, String input) {
        if (digit == null || digit.isEmpty()) {
            throw new ParserException("One part of the version is empty");
        }
        if (digit.length() > 1 && digit.startsWith("0")) {
            throw new ParserException("Numeric identifier MUST NOT contain leading zeroes (" + digit + " in " + input + ")");
        }
        try {
            return Integer.parseInt(digit);
        }
        catch (NumberFormatException nfe) {
            throw new ParserException("It was not possible to parse " + digit + " of " + input, nfe);
        }
    }
}

