/*
 * Decompiled with CFR 0.152.
 */
package com.intershop.release.version;

import com.intershop.release.version.DigitPos;
import com.intershop.release.version.MetadataVersion;
import com.intershop.release.version.NormalVersion;
import com.intershop.release.version.VersionExtension;
import com.intershop.release.version.VersionParser;
import com.intershop.release.version.VersionType;
import javax.annotation.Nonnull;

public class Version
implements Comparable<Version> {
    private final NormalVersion normal;
    private final MetadataVersion branchData;
    private final MetadataVersion buildData;
    private final VersionExtension extension;
    private final String orgString;
    public static final String METADATA_SEPARATOR = "-";

    public Version(NormalVersion normal, MetadataVersion branchData, MetadataVersion buildData, VersionExtension extension, String orgString) {
        this.normal = normal;
        this.branchData = branchData;
        this.buildData = buildData;
        this.extension = extension;
        this.orgString = orgString;
    }

    public Version(NormalVersion normal) {
        this(normal, MetadataVersion.NULL, MetadataVersion.NULL, VersionExtension.NONE, "");
    }

    public Version(NormalVersion normal, MetadataVersion branchData, MetadataVersion buildData) {
        this(normal, branchData, buildData, VersionExtension.NONE, "");
    }

    public Version(NormalVersion normal, MetadataVersion branchData, MetadataVersion buildData, VersionExtension extension) {
        this(normal, branchData, buildData, extension, "");
    }

    public static Version valueOf(String version) {
        return VersionParser.parseVersion(version);
    }

    public static Version forString(String version) {
        return Version.forString(version, VersionType.threeDigits);
    }

    public static Version forString(String version, VersionType type) {
        return VersionParser.parseVersion(version, type);
    }

    public static Version forIntegers(int major) {
        return Version.forIntegers(major, VersionType.threeDigits);
    }

    public static Version forIntegers(int major, VersionType type) {
        return Version.forIntegers(major, 0, type);
    }

    public static Version forIntegers(int major, int minor) {
        return Version.forIntegers(major, minor, VersionType.threeDigits);
    }

    public static Version forIntegers(int major, int minor, VersionType type) {
        return Version.forIntegers(major, minor, 0, type);
    }

    public static Version forIntegers(int major, int minor, int patch) {
        return Version.forIntegers(major, minor, patch, VersionType.threeDigits);
    }

    public static Version forIntegers(int major, int minor, int patch, VersionType type) {
        if (type == VersionType.fourDigits) {
            return Version.forIntegers(major, minor, patch, 0);
        }
        return new Version(new NormalVersion(major, minor, patch));
    }

    public static Version forIntegers(int major, int minor, int patch, int hotfix) {
        return new Version(new NormalVersion(major, minor, patch, hotfix));
    }

    public Version incrementMajorVersion() {
        return this.incrementMajorVersion("", "", "");
    }

    public Version incrementMajorVersion(String branchData) {
        return this.incrementMajorVersion(branchData, "", "");
    }

    public Version incrementMajorVersion(String branchData, String buildData, String versionExtension) {
        return this.increment(this.normal.incrementMajor(), branchData, buildData, versionExtension, false);
    }

    public Version incrementMinorVersion() {
        return this.incrementMinorVersion("", "", "");
    }

    public Version incrementMinorVersion(String branchData) {
        return this.incrementMinorVersion(branchData, "", "");
    }

    public Version incrementMinorVersion(String branchData, String buildData, String versionExtension) {
        return this.increment(this.normal.incrementMinor(), branchData, buildData, versionExtension, false);
    }

    public Version incrementPatchVersion() {
        return this.incrementPatchVersion("", "", "");
    }

    public Version incrementPatchVersion(String branchData) {
        return this.incrementPatchVersion(branchData, "", "");
    }

    public Version incrementPatchVersion(String branchData, String buildData, String versionExtension) {
        return this.increment(this.normal.incrementPatch(), branchData, buildData, versionExtension, false);
    }

    public Version incrementHotfixVersion() {
        return this.incrementHotfixVersion("", "", "");
    }

    public Version incrementHotfixVersion(String branchData) {
        return this.incrementHotfixVersion(branchData, "", "");
    }

    public Version incrementHotfixVersion(String branchData, String buildData, String versionExtension) {
        return this.increment(this.normal.incrementHotfix(), branchData, buildData, versionExtension, false);
    }

    public Version incrementLatest() {
        return this.incrementLatest(this.normal.getVersionType() == VersionType.threeDigits ? DigitPos.PATCH : DigitPos.HOTFIX, "", "", "");
    }

    public Version incrementLatest(DigitPos pos, String branchData, String buildData, String versionExtension) {
        return this.increment(this.normal.incrementLatest(pos), branchData, buildData, versionExtension, true);
    }

    public Version incrementVersion() {
        return this.incrementVersion(this.normal.getVersionType() == VersionType.threeDigits ? DigitPos.PATCH : DigitPos.HOTFIX);
    }

    public Version incrementVersion(DigitPos increment) {
        return this.incrementVersion(increment, "", "", "");
    }

    public Version incrementVersion(DigitPos increment, String branchData, String buildData, String versionExtension) {
        return this.increment(this.normal.incrementVersion(increment), branchData, buildData, versionExtension, true);
    }

    public Version incrementBuildMetadata() {
        return new Version(this.normal, this.branchData, this.buildData.increment());
    }

    private Version increment(NormalVersion normalNew, String branchDataNew, String buildDataNew, String extensionNew, boolean incrementBuild) {
        MetadataVersion branch = branchDataNew != null && !branchDataNew.isEmpty() ? VersionParser.parseBranchData(branchDataNew) : this.branchData;
        MetadataVersion build = buildDataNew != null && !buildDataNew.isEmpty() ? VersionParser.parseBuildData(buildDataNew) : this.buildData;
        VersionExtension extension = extensionNew != null && !extensionNew.isEmpty() ? VersionParser.parseVersionExtension(extensionNew) : this.extension;
        if (incrementBuild && !MetadataVersion.isEmpty(build)) {
            return new Version(this.normal, branch, build.increment(), extension);
        }
        return new Version(normalNew, branch, build, extension);
    }

    public Version setBranchMetadata(String branchData) {
        return new Version(this.normal, VersionParser.parseBranchData(branchData), this.buildData);
    }

    public Version setBuildMetadata(String buildData) {
        return new Version(this.normal, this.branchData, VersionParser.parseBuildData(buildData));
    }

    public Version setVersionExtension(String extension) {
        return new Version(this.normal, this.branchData, this.buildData, VersionParser.parseVersionExtension(extension));
    }

    public int getMajorVersion() {
        return this.normal.getMajor();
    }

    public int getMinorVersion() {
        return this.normal.getMinor();
    }

    public int getPatchVersion() {
        return this.normal.getPatch();
    }

    public int getHotfixVersion() {
        if (this.normal.getVersionType() == VersionType.fourDigits) {
            return this.normal.getHotfix();
        }
        throw new UnsupportedOperationException("This normal version does not support four digits");
    }

    public NormalVersion getNormalVersion() {
        return this.normal;
    }

    public MetadataVersion getBuildMetadata() {
        return this.buildData;
    }

    public MetadataVersion getBranchMetadata() {
        return this.branchData;
    }

    public VersionExtension getVersionExtension() {
        return this.extension;
    }

    public String toStringFor(int firstDigits) {
        return this.normal.toStringFor(firstDigits) + this.getSuffix();
    }

    public String toStringFromOrg() {
        if (this.orgString != null && !this.orgString.isEmpty()) {
            return this.orgString;
        }
        return this.toString();
    }

    public String toString() {
        return this.normal.toString() + this.getSuffix();
    }

    public String getSuffix() {
        String versionBranch = !MetadataVersion.isEmpty(this.getBranchMetadata()) ? METADATA_SEPARATOR + this.getBranchMetadata() : "";
        String versionBuild = !MetadataVersion.isEmpty(this.getBuildMetadata()) ? METADATA_SEPARATOR + this.getBuildMetadata() : "";
        String versionExtension = !VersionExtension.isEmpty(this.getVersionExtension()) ? METADATA_SEPARATOR + (Object)((Object)this.getVersionExtension()) : "";
        return versionBranch + versionBuild + versionExtension;
    }

    public Version clone() {
        return new Version(this.normal.clone(), this.branchData.clone(), this.buildData.clone(), this.extension, this.orgString);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.normal.hashCode();
        hash = 97 * hash + this.branchData.hashCode();
        hash = 97 * hash + this.buildData.hashCode();
        hash = 97 * hash + this.extension.hashCode();
        return hash;
    }

    @Override
    public int compareTo(@Nonnull Version other) {
        int result = this.normal.compareTo(other.normal);
        if (result == 0) {
            result = this.branchData.compareTo(other.branchData);
        }
        if (result == 0) {
            result = this.buildData.compareTo(other.buildData);
        }
        if (result == 0) {
            result = this.extension.compareTo(other.extension);
        }
        return result;
    }

    public static class Builder {
        private NormalVersion normal;
        private MetadataVersion branchData;
        private MetadataVersion buildData;
        private VersionType type;
        private VersionExtension extension;

        public Builder() {
            this(VersionType.threeDigits);
        }

        public Builder(VersionType type) {
            this(type == VersionType.threeDigits ? new NormalVersion(1, 0, 0) : new NormalVersion(1, 0, 0, 0), type);
        }

        public Builder(NormalVersion normal, VersionType type) {
            this.type = type;
            this.normal = normal;
            this.extension = VersionExtension.NONE;
        }

        public Builder setNormalVersion(NormalVersion normal) {
            this.type = VersionType.threeDigits;
            this.normal = normal;
            return this;
        }

        public Builder setNormalVersion(NormalVersion normal, VersionType type) {
            this.type = type;
            this.normal = normal;
            return this;
        }

        public Builder setBuildMetadata(MetadataVersion buildData) {
            this.buildData = buildData;
            return this;
        }

        public Builder setBranchMetadata(MetadataVersion branchData) {
            this.branchData = branchData;
            return this;
        }

        public Builder setVersionExtension(VersionExtension extension) {
            this.extension = extension;
            return this;
        }

        public Version build() {
            return new Version(this.normal, this.branchData, this.buildData, this.extension);
        }
    }
}

