/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

class PermissionHelper {
    private static final String PREFS = "intercom_composer_permission_status_prefs";
    private static final String ASKED_FOR_PERMISSION = "asked_for_permission";
    private final SharedPreferences sharedPreferences;
    private final Activity activity;

    static PermissionHelper create(Activity activity) {
        SharedPreferences preferences = activity.getSharedPreferences(PREFS, 0);
        return new PermissionHelper(activity, preferences);
    }

    PermissionHelper(Activity activity, SharedPreferences sharedPreferences) {
        this.activity = activity;
        this.sharedPreferences = sharedPreferences;
    }

    int getPermissionStatus(String androidPermissionName) {
        if (ContextCompat.checkSelfPermission((Context)this.activity, (String)androidPermissionName) == 0) {
            return 0;
        }
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)androidPermissionName)) {
            return 1;
        }
        if (this.sharedPreferences.getBoolean(ASKED_FOR_PERMISSION, false)) {
            return 2;
        }
        return 3;
    }

    void setAskedForPermissionPref(boolean asked) {
        this.sharedPreferences.edit().putBoolean(ASKED_FOR_PERMISSION, asked).apply();
    }
}

