/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Window;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.intercom.composer.WindowUtil;
import com.intercom.input.gallery.ClassUtils;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.GalleryLightBoxFragment;
import com.intercom.input.gallery.R;

public class GalleryLightBoxActivity
extends AppCompatActivity {
    private static final String KEY_FRAGMENT_CLASS = "fragment_class";
    @VisibleForTesting
    GalleryImage galleryImage;
    @VisibleForTesting
    FragmentManager fragmentManager;
    private Class<? extends GalleryLightBoxFragment> fragmentClass;

    public static Intent createIntent(Context context, GalleryImage galleryImage, Class<? extends GalleryLightBoxFragment> imageLoaderClass) {
        return new Intent(context, GalleryLightBoxActivity.class).putExtra("gallery_image", (Parcelable)galleryImage).putExtra(KEY_FRAGMENT_CLASS, imageLoaderClass);
    }

    protected void onCreate(Bundle bundle) {
        Window window = this.getWindow();
        super.onCreate(bundle);
        this.setContentView(R.layout.intercom_composer_activity_gallery_lightbox);
        WindowUtil.setFullscreenWindow((Window)window, (int)R.color.intercom_composer_status_bar);
        Intent intent = this.getIntent();
        this.galleryImage = (GalleryImage)intent.getParcelableExtra("gallery_image");
        this.fragmentClass = ClassUtils.cast(intent.getSerializableExtra(KEY_FRAGMENT_CLASS));
        this.fragmentManager = this.getSupportFragmentManager();
        if (this.fragmentManager.findFragmentById(R.id.fragment_container) == null) {
            GalleryLightBoxFragment fragment = ClassUtils.instantiate(this.fragmentClass);
            fragment.setArguments(GalleryLightBoxFragment.createArgs(this.galleryImage));
            this.fragmentManager.beginTransaction().replace(R.id.fragment_container, (Fragment)fragment).commit();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.overridePendingTransition(R.anim.intercom_composer_stay, R.anim.intercom_composer_slide_down);
    }
}

