/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import androidx.annotation.ColorInt;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityOptionsCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.intercom.composer.ImageLoader;
import com.intercom.composer.input.InputFragment;
import com.intercom.input.gallery.EmptyView;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.GalleryInputDataSource;
import com.intercom.input.gallery.GalleryInputExpandedListener;
import com.intercom.input.gallery.GalleryInputFullScreenActivity;
import com.intercom.input.gallery.GalleryInputScreen;
import com.intercom.input.gallery.GalleryLightBoxActivity;
import com.intercom.input.gallery.GalleryLightBoxFragment;
import com.intercom.input.gallery.GalleryOutputListener;
import com.intercom.input.gallery.HeadingMarginDecoration;
import com.intercom.input.gallery.R;
import com.intercom.input.gallery.adapter.EndlessRecyclerScrollListener;
import com.intercom.input.gallery.adapter.EndlessScrollListener;
import com.intercom.input.gallery.adapter.GalleryRecyclerViewAdapter;
import com.intercom.input.gallery.adapter.OnImageClickListener;
import java.util.ArrayList;
import java.util.List;

public abstract class GalleryInputFragment
extends InputFragment
implements GalleryInputScreen,
OnImageClickListener,
EndlessScrollListener {
    private static final String ARG_EXPANDED = "expanded";
    public static final int GALLERY_FULL_SCREEN_REQUEST_CODE = 14;
    private ImageLoader imageLoader;
    @VisibleForTesting
    boolean expanded;
    @VisibleForTesting
    @Nullable
    GalleryOutputListener galleryOutputListener;
    @VisibleForTesting
    @Nullable
    GalleryInputExpandedListener galleryInputExpandedListener;
    @VisibleForTesting
    GalleryRecyclerViewAdapter recyclerAdapter;
    @VisibleForTesting
    GalleryInputDataSource dataSource;
    @VisibleForTesting
    final List<GalleryImage> galleryImages = new ArrayList<GalleryImage>();
    @VisibleForTesting
    LinearLayoutManager layoutManager;
    @VisibleForTesting
    EndlessRecyclerScrollListener endlessRecyclerScrollListener;
    @VisibleForTesting
    RecyclerView recyclerView;
    @VisibleForTesting
    EmptyView emptyLayout;
    @VisibleForTesting
    FrameLayout contentLayout;
    @VisibleForTesting
    Injector injector;
    @VisibleForTesting
    final GalleryInputDataSource.Listener dataListener = new GalleryInputDataSource.Listener(){

        @Override
        public void onSuccess(List<GalleryImage> images) {
            GalleryInputFragment.this.galleryImages.clear();
            GalleryInputFragment.this.galleryImages.addAll(images);
            GalleryInputFragment.this.endlessRecyclerScrollListener.setMaxCount(GalleryInputFragment.this.dataSource.getCount());
            GalleryInputFragment.this.recyclerAdapter.notifyDataSetChanged();
            if (GalleryInputFragment.this.isAdded()) {
                GalleryInputFragment.this.showEmptyOrPermissionScreen(0);
            }
        }

        @Override
        public void onError() {
            if (GalleryInputFragment.this.isAdded()) {
                GalleryInputFragment.this.showErrorScreen();
            }
        }
    };
    private final View.OnClickListener expanderClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (GalleryInputFragment.this.galleryInputExpandedListener != null) {
                GalleryInputFragment.this.galleryInputExpandedListener.onInputExpanded();
            }
            Intent intent = GalleryInputFullScreenActivity.createIntent((Context)GalleryInputFragment.this.getActivity(), GalleryInputFragment.this.getClass(), GalleryInputFragment.this.getArguments());
            Bundle options = ActivityOptionsCompat.makeCustomAnimation((Context)GalleryInputFragment.this.getActivity(), (int)R.anim.intercom_composer_slide_up, (int)R.anim.intercom_composer_stay).toBundle();
            GalleryInputFragment.this.startActivityForResult(intent, 14, options);
        }
    };

    public static Bundle createArguments(boolean expanded) {
        Bundle args = new Bundle();
        args.putBoolean(ARG_EXPANDED, expanded);
        return args;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof GalleryOutputListener) {
            this.galleryOutputListener = (GalleryOutputListener)context;
        }
        if (context instanceof GalleryInputExpandedListener) {
            this.galleryInputExpandedListener = (GalleryInputExpandedListener)context;
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.expanded = args.getBoolean(ARG_EXPANDED, false);
        }
        if (this.expanded) {
            int columnCount = this.getResources().getInteger(R.integer.intercom_composer_expanded_column_count);
            this.layoutManager = new GridLayoutManager(this.getContext(), columnCount);
        } else {
            this.layoutManager = new LinearLayoutManager(this.getContext(), 0, false);
        }
        this.injector = this.getInjector(this);
        this.dataSource = this.injector.getDataSource(this);
        this.dataSource.setListener(this.dataListener);
        this.imageLoader = this.injector.getImageLoader(this);
        this.endlessRecyclerScrollListener = new EndlessRecyclerScrollListener(this.layoutManager, this);
        this.recyclerAdapter = new GalleryRecyclerViewAdapter(LayoutInflater.from((Context)this.getContext()), this.galleryImages, this.expanded, this, this.imageLoader);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle bundle) {
        View view = inflater.inflate(this.getLayoutRes(), container, false);
        ViewGroup rootView = (ViewGroup)view.findViewById(R.id.gallery_root_view);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.gallery_recycler_view);
        this.emptyLayout = (EmptyView)view.findViewById(R.id.gallery_empty_view);
        this.contentLayout = (FrameLayout)view.findViewById(R.id.gallery_content_layout);
        if (this.expanded) {
            this.setUpAppBar(this.injector, rootView);
            this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new HeadingMarginDecoration(R.dimen.intercom_composer_toolbar_height));
        } else {
            this.setUpPreviewViews(this.injector, rootView);
        }
        this.emptyLayout.setActionButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                switch (GalleryInputFragment.this.dataSource.getPermissionStatus()) {
                    case 1: 
                    case 3: {
                        GalleryInputFragment.this.dataSource.requestPermission();
                        break;
                    }
                    case 2: {
                        GalleryInputFragment.this.showPermissionPermanentlyDeniedDialog();
                        break;
                    }
                }
            }
        });
        this.emptyLayout.setThemeColor(this.injector.getThemeColor(this.getContext()));
        return view;
    }

    protected void setUpAppBar(Injector injector, ViewGroup rootView) {
        Toolbar toolbar = injector.getToolbar(rootView);
        rootView.addView((View)toolbar);
        ((AppCompatActivity)this.getActivity()).setSupportActionBar(toolbar);
        ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setDisplayShowHomeEnabled(true);
            actionBar.setDisplayShowTitleEnabled(false);
        }
    }

    private void setUpPreviewViews(Injector injector, ViewGroup rootView) {
        View searchView;
        ImageButton expandButton = (ImageButton)injector.getExpanderButton((ViewGroup)this.contentLayout);
        if (expandButton != null) {
            this.contentLayout.addView((View)expandButton);
            expandButton.setOnClickListener(this.expanderClickListener);
        }
        if ((searchView = injector.getSearchView((ViewGroup)this.contentLayout)) != null) {
            searchView.setOnClickListener(this.expanderClickListener);
            rootView.addView(searchView, 0);
        }
    }

    @VisibleForTesting
    @LayoutRes
    int getLayoutRes() {
        return this.expanded ? R.layout.intercom_composer_fragment_composer_gallery_expanded : R.layout.intercom_composer_fragment_composer_gallery;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerAdapter);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.endlessRecyclerScrollListener);
        if (this.expanded) {
            this.onInputSelected();
        }
        this.endlessRecyclerScrollListener.setMaxCount(this.dataSource.getCount());
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.endlessRecyclerScrollListener);
        this.recyclerView.setLayoutManager(null);
    }

    @Override
    public void onLoadMore() {
        if (!this.galleryImages.isEmpty() && !this.dataSource.isLoading()) {
            this.dataSource.getImages(this.galleryImages.size(), null);
        }
    }

    @Override
    public void onImageClicked(RecyclerView.ViewHolder holder) {
        int position = holder.getAdapterPosition();
        if (position > -1 && position < this.recyclerAdapter.getItemCount()) {
            GalleryImage galleryImage = this.recyclerAdapter.getItem(position);
            this.launchLightBoxActivity(galleryImage);
        }
    }

    @VisibleForTesting
    void launchLightBoxActivity(GalleryImage galleryImage) {
        FragmentActivity activity = this.getActivity();
        Intent intent = GalleryLightBoxActivity.createIntent((Context)activity, galleryImage, this.getInjector(this).getLightBoxFragmentClass(this));
        Bundle options = ActivityOptionsCompat.makeCustomAnimation((Context)activity, (int)R.anim.intercom_composer_slide_up, (int)R.anim.intercom_composer_stay).toBundle();
        this.startActivityForResult(intent, 14, options);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.checkPermissionAndFetchImages(false);
    }

    @VisibleForTesting
    void showEmptyOrPermissionScreen(int permissionStatus) {
        switch (permissionStatus) {
            case 1: 
            case 2: {
                this.emptyLayout.setVisibility(0);
                this.emptyLayout.setTitle(R.string.intercom_photo_access_denied);
                this.emptyLayout.setSubtitle(R.string.intercom_allow_storage_access);
                this.emptyLayout.setActionButtonVisibility(0);
                this.contentLayout.setVisibility(8);
                break;
            }
            case 3: {
                this.emptyLayout.setVisibility(0);
                this.emptyLayout.setTitle(R.string.intercom_access_photos);
                this.emptyLayout.setSubtitle(R.string.intercom_storage_access_request);
                this.emptyLayout.setActionButtonVisibility(8);
                this.contentLayout.setVisibility(8);
                break;
            }
            case 0: {
                if (this.galleryImages.isEmpty()) {
                    this.emptyLayout.setVisibility(0);
                    this.emptyLayout.setActionButtonVisibility(8);
                    this.emptyLayout.setTitle(this.injector.getEmptyViewTitle(this.getResources()));
                    this.emptyLayout.setSubtitle(this.injector.getEmptyViewSubtitle(this.getResources()));
                    this.contentLayout.setVisibility(8);
                    break;
                }
                this.emptyLayout.setVisibility(8);
                this.contentLayout.setVisibility(0);
            }
        }
    }

    @VisibleForTesting
    void showErrorScreen() {
        this.emptyLayout.setVisibility(0);
        this.emptyLayout.setActionButtonVisibility(8);
        this.emptyLayout.setTitle(this.injector.getErrorViewTitle(this.getResources()));
        this.emptyLayout.setSubtitle(this.injector.getErrorViewSubtitle(this.getResources()));
        this.contentLayout.setVisibility(8);
    }

    protected void passDataOnViewCreated(@Nullable Bundle arguments) {
    }

    public void onInputSelected() {
        this.checkPermissionAndFetchImages(true);
    }

    @VisibleForTesting
    void checkPermissionAndFetchImages(boolean requestPermissionsAgain) {
        int permissionStatus = this.dataSource.getPermissionStatus();
        switch (permissionStatus) {
            case 1: 
            case 3: {
                this.showEmptyOrPermissionScreen(permissionStatus);
                if (!requestPermissionsAgain) break;
                this.dataSource.requestPermission();
                break;
            }
            case 2: {
                this.showEmptyOrPermissionScreen(permissionStatus);
                if (!requestPermissionsAgain) break;
                this.showPermissionPermanentlyDeniedDialog();
                break;
            }
            default: {
                this.fetchImagesIfNotFetched();
            }
        }
    }

    private void showPermissionPermanentlyDeniedDialog() {
        new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.intercom_photo_access_denied).setMessage(R.string.intercom_go_to_device_settings).setPositiveButton(R.string.intercom_app_settings, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Uri uri = Uri.fromParts((String)"package", (String)GalleryInputFragment.this.getActivity().getPackageName(), null);
                GalleryInputFragment.this.startActivity(new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", uri));
            }
        }).setNegativeButton(R.string.intercom_not_now, null).show();
    }

    public void onInputReselected() {
    }

    public void onInputDeselected() {
    }

    public void setGalleryListener(@Nullable GalleryOutputListener listener) {
        this.galleryOutputListener = listener;
    }

    public void setGalleryExpandedListener(@Nullable GalleryInputExpandedListener listener) {
        this.galleryInputExpandedListener = listener;
    }

    @VisibleForTesting
    void fetchImagesIfNotFetched() {
        if (this.galleryImages.isEmpty()) {
            this.dataSource.getImages(0, null);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 14 && resultCode == -1) {
            if (this.galleryOutputListener != null) {
                GalleryImage galleryImage = (GalleryImage)data.getParcelableExtra("gallery_image");
                this.galleryOutputListener.onGalleryOutputReceived(galleryImage);
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    protected abstract Injector getInjector(GalleryInputFragment var1);

    public static interface Injector {
        @Nullable
        public View getExpanderButton(ViewGroup var1);

        @Nullable
        public View getSearchView(ViewGroup var1);

        public Toolbar getToolbar(ViewGroup var1);

        @ColorInt
        public int getThemeColor(Context var1);

        public GalleryInputDataSource getDataSource(GalleryInputFragment var1);

        public ImageLoader getImageLoader(GalleryInputFragment var1);

        public Class<? extends GalleryLightBoxFragment> getLightBoxFragmentClass(GalleryInputFragment var1);

        public String getEmptyViewTitle(Resources var1);

        public String getEmptyViewSubtitle(Resources var1);

        public String getErrorViewTitle(Resources var1);

        public String getErrorViewSubtitle(Resources var1);
    }
}

