/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.intercom.input.gallery.R;

public class EmptyView
extends LinearLayout {
    private TextView title;
    private TextView subtitle;
    private Button actionButton;
    private String titleText;
    private String subtitleText;
    private String actionButtonText;
    private int internalPaddingTop;
    private int internalPaddingBottom;
    private int internalPaddingLeft;
    private int internalPaddingRight;

    public EmptyView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmptyView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.intercom_composer_empty_view, (ViewGroup)this, true);
        this.setBackgroundResource(R.color.intercom_composer_white);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.intercom_composer_empty_view, 0, 0);
        try {
            this.titleText = typedArray.getString(R.styleable.intercom_composer_empty_view_intercom_composer_titleText);
            this.subtitleText = typedArray.getString(R.styleable.intercom_composer_empty_view_intercom_composer_subtitleText);
            this.actionButtonText = typedArray.getString(R.styleable.intercom_composer_empty_view_intercom_composer_actionButtonText);
            this.internalPaddingTop = typedArray.getDimensionPixelSize(R.styleable.intercom_composer_empty_view_intercom_composer_internalPaddingTop, 0);
            this.internalPaddingBottom = typedArray.getDimensionPixelSize(R.styleable.intercom_composer_empty_view_intercom_composer_internalPaddingBottom, 0);
            this.internalPaddingLeft = typedArray.getDimensionPixelSize(R.styleable.intercom_composer_empty_view_intercom_composer_internalPaddingLeft, 0);
            this.internalPaddingRight = typedArray.getDimensionPixelSize(R.styleable.intercom_composer_empty_view_intercom_composer_internalPaddingRight, 0);
        }
        catch (RuntimeException e) {
            this.titleText = "";
            this.subtitleText = "";
            this.actionButtonText = "";
            this.internalPaddingTop = 0;
            this.internalPaddingBottom = 0;
            this.internalPaddingLeft = 0;
            this.internalPaddingRight = 0;
        }
        finally {
            typedArray.recycle();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.title = (TextView)this.findViewById(R.id.empty_text_title);
        this.subtitle = (TextView)this.findViewById(R.id.empty_text_subtitle);
        this.actionButton = (Button)this.findViewById(R.id.empty_action_button);
        this.title.setText((CharSequence)this.titleText);
        this.subtitle.setText((CharSequence)this.subtitleText);
        if (!TextUtils.isEmpty((CharSequence)this.actionButtonText)) {
            this.actionButton.setText((CharSequence)this.actionButtonText);
        } else {
            this.actionButton.setVisibility(8);
        }
        LinearLayout emptyViewLayout = (LinearLayout)this.findViewById(R.id.empty_view_layout);
        emptyViewLayout.setPadding(this.internalPaddingLeft, this.internalPaddingTop, this.internalPaddingRight, this.internalPaddingBottom);
    }

    public void setTitle(CharSequence titleText) {
        this.title.setText(titleText);
    }

    public void setSubtitle(CharSequence subtitleText) {
        this.subtitle.setText(subtitleText);
    }

    public void setActionButtonClickListener(View.OnClickListener onClickListener) {
        this.actionButton.setOnClickListener(onClickListener);
    }

    public void setTitle(@StringRes int text) {
        this.title.setText(text);
    }

    public void setSubtitle(@StringRes int text) {
        this.subtitle.setText(text);
    }

    public void setActionButtonVisibility(int visibility) {
        this.actionButton.setVisibility(visibility);
    }

    public void setThemeColor(@ColorInt int themeColor) {
        this.actionButton.setBackgroundColor(themeColor);
    }
}

