/*
 * Decompiled with CFR 0.152.
 */
package com.interaso.webpush;

import com.interaso.webpush.CryptoKt;
import com.interaso.webpush.VapidKeys;
import com.interaso.webpush.WebPushStatusException;
import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 #2\u00020\u0001:\u0003#$%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eJ=\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\f\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J=\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u001b\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0003J\u0018\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\b\b\u0002\u0010\"\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"Lcom/interaso/webpush/WebPush;", "", "subject", "", "vapidKeys", "Lcom/interaso/webpush/VapidKeys;", "(Ljava/lang/String;Lcom/interaso/webpush/VapidKeys;)V", "getSubject", "()Ljava/lang/String;", "getVapidKeys", "()Lcom/interaso/webpush/VapidKeys;", "getAudience", "endpoint", "getBody", "", "payload", "p256dh", "auth", "getHeaders", "", "ttl", "", "topic", "urgency", "Lcom/interaso/webpush/WebPush$Urgency;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/interaso/webpush/WebPush$Urgency;)Ljava/util/Map;", "getHeadersWithToken", "token", "getSubscriptionState", "Lcom/interaso/webpush/WebPush$SubscriptionState;", "statusCode", "body", "getToken", "audience", "expiration", "Companion", "SubscriptionState", "Urgency", "webpush"})
@SourceDebugExtension(value={"SMAP\nWebPush.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPush.kt\ncom/interaso/webpush/WebPush\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class WebPush {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String subject;
    @NotNull
    private final VapidKeys vapidKeys;
    private static final int DEFAULT_TTL = 2419200;
    @NotNull
    private static final byte[] webPushInfo;
    @NotNull
    private static final byte[] keyInfo;
    @NotNull
    private static final byte[] nonceInfo;

    public WebPush(@NotNull String subject, @NotNull VapidKeys vapidKeys) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)vapidKeys, (String)"vapidKeys");
        this.subject = subject;
        this.vapidKeys = vapidKeys;
        if (!(StringsKt.startsWith$default((String)this.subject, (String)"mailto:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.subject, (String)"https://", (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "Subject must start with 'mailto:' or 'https://'";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getSubject() {
        return this.subject;
    }

    @NotNull
    public final VapidKeys getVapidKeys() {
        return this.vapidKeys;
    }

    @NotNull
    public final byte[] getBody(@NotNull byte[] payload, @NotNull byte[] p256dh, @NotNull byte[] auth) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)p256dh, (String)"p256dh");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        ECPublicKey userPublicKey = CryptoKt.generatePublicKeyFromUncompressedBytes(p256dh);
        KeyPair auxKeyPair = CryptoKt.generateSecp256r1KeyPair();
        PublicKey publicKey = auxKeyPair.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        byte[] auxPublicKey = CryptoKt.getUncompressedBytes((ECPublicKey)publicKey);
        PrivateKey privateKey = auxKeyPair.getPrivate();
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
        byte[] secret = CryptoKt.generateEcdhSharedSecret((ECPrivateKey)privateKey, userPublicKey);
        byte[] salt = CryptoKt.generateSalt(16);
        byte[][] byArrayArray = new byte[][]{webPushInfo, p256dh, auxPublicKey};
        byte[] secretInfo = CryptoKt.concatBytes(byArrayArray);
        byte[] derivedSecret = CryptoKt.hkdfSha256(secret, auth, secretInfo, 32);
        byte[] derivedKey = CryptoKt.hkdfSha256(derivedSecret, salt, keyInfo, 16);
        byte[] derivedNonce = CryptoKt.hkdfSha256(derivedSecret, salt, nonceInfo, 12);
        Object object = new byte[]{2};
        byte[] encryptedPayload = CryptoKt.encryptAesGcmNoPadding(derivedKey, derivedNonce, ArraysKt.plus((byte[])payload, (byte[])object));
        object = new byte[5][];
        object[0] = (byte)salt;
        byte[] byArray = new byte[]{0, 0, 16, 0};
        object[1] = (byte)byArray;
        byArray = new byte[]{(byte)auxPublicKey.length};
        object[2] = (byte)byArray;
        object[3] = (byte)auxPublicKey;
        object[4] = (byte)encryptedPayload;
        return CryptoKt.concatBytes((byte[][])object);
    }

    @NotNull
    public final Map<String, String> getHeaders(@NotNull String endpoint, @Nullable Integer ttl, @Nullable String topic, @Nullable Urgency urgency) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return this.getHeadersWithToken(WebPush.getToken$default(this, this.getAudience(endpoint), 0, 2, null), ttl, topic, urgency);
    }

    @NotNull
    public final String getAudience(@NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        URI $this$getAudience_u24lambda_u241 = new URI(endpoint);
        boolean bl = false;
        return $this$getAudience_u24lambda_u241.getScheme() + "://" + $this$getAudience_u24lambda_u241.getAuthority();
    }

    @NotNull
    public final String getToken(@NotNull String audience, int expiration) {
        Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
        return CryptoKt.createEs256Jwt(this.subject, audience, expiration, this.vapidKeys.getPrivateKey());
    }

    public static /* synthetic */ String getToken$default(WebPush webPush, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 43200;
        }
        return webPush.getToken(string, n);
    }

    @NotNull
    public final Map<String, String> getHeadersWithToken(@NotNull String token, @Nullable Integer ttl, @Nullable String topic, @Nullable Urgency urgency) {
        Map map;
        block1: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Map $this$getHeadersWithToken_u24lambda_u244 = map = MapsKt.createMapBuilder((int)6);
            boolean bl = false;
            $this$getHeadersWithToken_u24lambda_u244.put("Authorization", "vapid t=" + token + ", k=" + CryptoKt.encodeBase64(this.vapidKeys.getApplicationServerKey()));
            $this$getHeadersWithToken_u24lambda_u244.put("Content-Encoding", "aes128gcm");
            $this$getHeadersWithToken_u24lambda_u244.put("Content-Type", "application/octet-stream");
            Integer n = ttl;
            $this$getHeadersWithToken_u24lambda_u244.put("TTL", String.valueOf(n != null ? n : 2419200));
            Urgency urgency2 = urgency;
            if (urgency2 != null) {
                it = urgency2;
                boolean bl2 = false;
                $this$getHeadersWithToken_u24lambda_u244.put("Urgency", urgency.getHeaderValue$webpush());
            }
            String string = topic;
            if (string == null) break block1;
            it = string;
            boolean bl3 = false;
            $this$getHeadersWithToken_u24lambda_u244.put("Topic", topic);
        }
        return MapsKt.build((Map)map);
    }

    @NotNull
    public final SubscriptionState getSubscriptionState(int statusCode, @Nullable String body) {
        SubscriptionState subscriptionState;
        switch (statusCode) {
            case 200: 
            case 201: 
            case 202: {
                subscriptionState = SubscriptionState.ACTIVE;
                break;
            }
            case 404: 
            case 410: {
                subscriptionState = SubscriptionState.EXPIRED;
                break;
            }
            case 401: 
            case 403: {
                throw new WebPushStatusException(statusCode, "Authentication failed: [" + statusCode + "] - " + body, null, 4, null);
            }
            case 502: 
            case 503: {
                throw new WebPushStatusException(statusCode, "Service unavailable: [" + statusCode + "] - " + body, null, 4, null);
            }
            default: {
                throw new WebPushStatusException(statusCode, "Unexpected response: [" + statusCode + "] - " + body, null, 4, null);
            }
        }
        return subscriptionState;
    }

    public static /* synthetic */ SubscriptionState getSubscriptionState$default(WebPush webPush, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        return webPush.getSubscriptionState(n, string);
    }

    static {
        String string = "WebPush: info\u0000";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        webPushInfo = byArray;
        string = "Content-Encoding: aes128gcm\u0000";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        keyInfo = byArray2;
        string = "Content-Encoding: nonce\u0000";
        byte[] byArray3 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        nonceInfo = byArray3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/interaso/webpush/WebPush$Companion;", "", "()V", "DEFAULT_TTL", "", "keyInfo", "", "nonceInfo", "webPushInfo", "webpush"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/interaso/webpush/WebPush$SubscriptionState;", "", "(Ljava/lang/String;I)V", "ACTIVE", "EXPIRED", "webpush"})
    public static final class SubscriptionState
    extends Enum<SubscriptionState> {
        public static final /* enum */ SubscriptionState ACTIVE = new SubscriptionState();
        public static final /* enum */ SubscriptionState EXPIRED = new SubscriptionState();
        private static final /* synthetic */ SubscriptionState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SubscriptionState[] values() {
            return (SubscriptionState[])$VALUES.clone();
        }

        public static SubscriptionState valueOf(String value) {
            return Enum.valueOf(SubscriptionState.class, value);
        }

        @NotNull
        public static EnumEntries<SubscriptionState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = subscriptionStateArray = new SubscriptionState[]{SubscriptionState.ACTIVE, SubscriptionState.EXPIRED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/interaso/webpush/WebPush$Urgency;", "", "headerValue", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getHeaderValue$webpush", "()Ljava/lang/String;", "VeryLow", "Low", "Normal", "High", "webpush"})
    public static final class Urgency
    extends Enum<Urgency> {
        @NotNull
        private final String headerValue;
        public static final /* enum */ Urgency VeryLow = new Urgency("very-low");
        public static final /* enum */ Urgency Low = new Urgency("low");
        public static final /* enum */ Urgency Normal = new Urgency("normal");
        public static final /* enum */ Urgency High = new Urgency("high");
        private static final /* synthetic */ Urgency[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Urgency(String headerValue) {
            this.headerValue = headerValue;
        }

        @NotNull
        public final String getHeaderValue$webpush() {
            return this.headerValue;
        }

        public static Urgency[] values() {
            return (Urgency[])$VALUES.clone();
        }

        public static Urgency valueOf(String value) {
            return Enum.valueOf(Urgency.class, value);
        }

        @NotNull
        public static EnumEntries<Urgency> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = urgencyArray = new Urgency[]{Urgency.VeryLow, Urgency.Low, Urgency.Normal, Urgency.High};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

