/*
 * Decompiled with CFR 0.152.
 */
package com.ib.controller;

import com.ib.client.Contract;
import com.ib.client.EClientErrors;
import com.ib.client.EClientSocket;
import com.ib.client.EJavaSignal;
import com.ib.client.EMessage;
import com.ib.client.EWrapper;
import com.ib.client.Order;
import java.io.IOException;

public class ApiConnection
extends EClientSocket {
    public static final char EOL = '\u0000';
    public static final char LOG_EOL = '_';
    private final ILogger m_inLogger;
    private final ILogger m_outLogger;
    private static final EJavaSignal m_signal = new EJavaSignal();

    public ApiConnection(EWrapper wrapper, ILogger inLogger, ILogger outLogger) {
        super(wrapper, m_signal);
        this.m_inLogger = inLogger;
        this.m_outLogger = outLogger;
    }

    @Override
    protected void sendMsg(EMessage msg) throws IOException {
        super.sendMsg(msg);
        byte[] buf = msg.getRawData();
        this.m_outLogger.log(new String(buf, 0, buf.length));
    }

    @Override
    public int readInt() throws IOException {
        int c = super.readInt();
        this.m_inLogger.log(String.valueOf((char)c));
        return c;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int n = super.read(buf, off, len);
        this.m_inLogger.log(new String(buf, 0, n));
        return n;
    }

    public synchronized void placeOrder(Contract contract, Order order) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.serverVersion() < 66) {
            this.error(-1, EClientErrors.UPDATE_TWS, "ApiController requires TWS build 932 or higher to place orders.");
            return;
        }
        this.placeOrder(order.orderId(), contract, order);
    }

    public static interface ILogger {
        public void log(String var1);
    }
}

