/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.IApiEnum;

public class Types {
    public static <T extends Enum<?>> T getValueOf(String v, T[] values, T defaultValue) {
        for (T currentEnum : values) {
            if (!((IApiEnum)currentEnum).getApiString().equals(v)) continue;
            return currentEnum;
        }
        return defaultValue;
    }

    public static <T extends Enum<T>> T getEnum(int ordinal, T[] values) {
        if (ordinal == Integer.MAX_VALUE) {
            return null;
        }
        for (T val : values) {
            if (((Enum)val).ordinal() != ordinal) continue;
            return val;
        }
        String str = String.format("Error: %s is not a valid value for enum %s", ordinal, values[0].getClass().getName());
        throw new IllegalArgumentException(str);
    }

    public static enum Method implements IApiEnum
    {
        None,
        EqualQuantity,
        AvailableEquity,
        NetLiq,
        PctChange;


        public static Method get(String str) {
            return (Method)Types.getValueOf((String)str, (Enum[])Method.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this == None ? "" : super.toString();
        }
    }

    public static enum MktDataType {
        Unknown,
        Realtime,
        Frozen;


        public static MktDataType get(int ordinal) {
            return (MktDataType)Types.getEnum((int)ordinal, (Enum[])MktDataType.values());
        }
    }

    public static enum SecType implements IApiEnum
    {
        None,
        STK,
        OPT,
        FUT,
        CASH,
        BOND,
        CFD,
        FOP,
        WAR,
        IOPT,
        FWD,
        BAG,
        IND,
        BILL,
        FUND,
        FIXED,
        SLB,
        NEWS,
        CMDTY,
        BSK,
        ICU,
        ICS;


        public static SecType get(String str) {
            return (SecType)Types.getValueOf((String)str, (Enum[])SecType.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this == None ? "" : super.toString();
        }
    }

    public static enum SecIdType implements IApiEnum
    {
        None,
        CUSIP,
        SEDOL,
        ISIN,
        RIC;


        public static SecIdType get(String str) {
            return (SecIdType)Types.getValueOf((String)str, (Enum[])SecIdType.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this == None ? "" : super.toString();
        }
    }

    public static enum FADataType {
        UNUSED,
        GROUPS,
        PROFILES,
        ALIASES;


        public static FADataType get(int ordinal) {
            return (FADataType)Types.getEnum((int)ordinal, (Enum[])FADataType.values());
        }
    }

    public static enum NewsType {
        UNKNOWN,
        BBS,
        LIVE_EXCH,
        DEAD_EXCH,
        HTML,
        POPUP_TEXT,
        POPUP_HTML;


        public static NewsType get(int ordinal) {
            return (NewsType)Types.getEnum((int)ordinal, (Enum[])NewsType.values());
        }
    }

    public static enum DeepSide {
        SELL,
        BUY;


        public static DeepSide get(int ordinal) {
            return (DeepSide)Types.getEnum((int)ordinal, (Enum[])DeepSide.values());
        }
    }

    public static enum DeepType {
        INSERT,
        UPDATE,
        DELETE;


        public static DeepType get(int ordinal) {
            return (DeepType)Types.getEnum((int)ordinal, (Enum[])DeepType.values());
        }
    }

    public static enum DurationUnit {
        SECOND,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }

    public static enum BarSize {
        _1_secs,
        _5_secs,
        _10_secs,
        _15_secs,
        _30_secs,
        _1_min,
        _2_mins,
        _3_mins,
        _5_mins,
        _10_mins,
        _15_mins,
        _20_mins,
        _30_mins,
        _1_hour,
        _4_hours,
        _1_day,
        _1_week;


        public String toString() {
            return super.toString().substring(1).replace('_', ' ');
        }
    }

    public static enum WhatToShow {
        TRADES,
        MIDPOINT,
        BID,
        ASK,
        BID_ASK,
        HISTORICAL_VOLATILITY,
        OPTION_IMPLIED_VOLATILITY,
        YIELD_ASK,
        YIELD_BID,
        YIELD_BID_ASK,
        YIELD_LAST;

    }

    public static enum FundamentalType {
        ReportSnapshot,
        ReportsFinSummary,
        ReportRatios,
        ReportsFinStatements,
        RESC,
        CalendarReport;


        public String getApiString() {
            return super.toString();
        }

        public String toString() {
            switch (this) {
                case ReportSnapshot: {
                    return "Company overview";
                }
                case ReportsFinSummary: {
                    return "Financial summary";
                }
                case ReportRatios: {
                    return "Financial ratios";
                }
                case ReportsFinStatements: {
                    return "Financial statements";
                }
                case RESC: {
                    return "Analyst estimates";
                }
                case CalendarReport: {
                    return "Company calendar";
                }
            }
            return null;
        }
    }

    public static enum ExerciseType {
        None,
        Exercise,
        Lapse;

    }

    public static enum TimeInForce implements IApiEnum
    {
        DAY,
        GTC,
        OPG,
        IOC,
        GTD,
        GTT,
        AUC,
        FOK,
        GTX,
        DTC;


        public static TimeInForce get(String apiString) {
            return (TimeInForce)Types.getValueOf((String)apiString, (Enum[])TimeInForce.values(), null);
        }

        @Override
        public String getApiString() {
            return this.toString();
        }
    }

    public static enum OcaType implements IApiEnum
    {
        None,
        CancelWithBlocking,
        ReduceWithBlocking,
        ReduceWithoutBlocking;


        public static OcaType get(int ordinal) {
            return (OcaType)Types.getEnum((int)ordinal, (Enum[])OcaType.values());
        }

        @Override
        public String getApiString() {
            return String.valueOf(this.ordinal());
        }
    }

    public static enum Rule80A implements IApiEnum
    {
        None(""),
        IndivArb("J"),
        IndivBigNonArb("K"),
        IndivSmallNonArb("I"),
        INST_ARB("U"),
        InstBigNonArb("Y"),
        InstSmallNonArb("A");

        private String m_apiString;

        private Rule80A(String apiString) {
            this.m_apiString = apiString;
        }

        public static Rule80A get(String apiString) {
            return (Rule80A)Types.getValueOf((String)apiString, (Enum[])Rule80A.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this.m_apiString;
        }
    }

    public static enum Action implements IApiEnum
    {
        BUY,
        SELL,
        SSHORT;


        public static Action get(String apiString) {
            return (Action)Types.getValueOf((String)apiString, (Enum[])Action.values(), null);
        }

        @Override
        public String getApiString() {
            return this.toString();
        }
    }

    public static enum TriggerMethod implements IApiEnum
    {
        Default(0),
        DoubleBidAsk(1),
        Last(2),
        DoubleLast(3),
        BidAsk(4),
        LastOrBidAsk(7),
        Midpoint(8);

        int m_val;

        public int val() {
            return this.m_val;
        }

        private TriggerMethod(int val) {
            this.m_val = val;
        }

        public static TriggerMethod get(int val) {
            for (TriggerMethod m : TriggerMethod.values()) {
                if (m.m_val != val) continue;
                return m;
            }
            return null;
        }

        @Override
        public String getApiString() {
            return String.valueOf(this.m_val);
        }
    }

    public static enum ReferencePriceType implements IApiEnum
    {
        None,
        Midpoint,
        BidOrAsk;


        public static ReferencePriceType get(int ordinal) {
            return (ReferencePriceType)Types.getEnum((int)ordinal, (Enum[])ReferencePriceType.values());
        }

        @Override
        public String getApiString() {
            return String.valueOf(this.ordinal());
        }
    }

    public static enum VolatilityType implements IApiEnum
    {
        None,
        Daily,
        Annual;


        public static VolatilityType get(int ordinal) {
            return ordinal == Integer.MAX_VALUE ? None : (VolatilityType)Types.getEnum((int)ordinal, (Enum[])VolatilityType.values());
        }

        @Override
        public String getApiString() {
            return String.valueOf(this.ordinal());
        }
    }

    public static enum Right implements IApiEnum
    {
        None,
        Put,
        Call;


        public static Right get(String apiString) {
            if (apiString != null && apiString.length() > 0) {
                switch (apiString.charAt(0)) {
                    case 'P': {
                        return Put;
                    }
                    case 'C': {
                        return Call;
                    }
                }
            }
            return None;
        }

        @Override
        public String getApiString() {
            return this == None ? "" : String.valueOf(this.toString().charAt(0));
        }
    }

    public static enum HedgeType implements IApiEnum
    {
        None,
        Delta,
        Beta,
        Fx,
        Pair;


        public static HedgeType get(String apiString) {
            return (HedgeType)Types.getValueOf((String)apiString, (Enum[])HedgeType.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this == None ? "" : String.valueOf(super.toString().charAt(0));
        }
    }

    public static enum AlgoStrategy implements IApiEnum
    {
        None(new AlgoParam[0]),
        Vwap(AlgoParam.startTime, AlgoParam.endTime, AlgoParam.maxPctVol, AlgoParam.noTakeLiq, AlgoParam.getDone, AlgoParam.noTradeAhead, AlgoParam.useOddLots),
        Twap(AlgoParam.startTime, AlgoParam.endTime, AlgoParam.allowPastEndTime, AlgoParam.strategyType),
        ArrivalPx(AlgoParam.startTime, AlgoParam.endTime, AlgoParam.allowPastEndTime, AlgoParam.maxPctVol, AlgoParam.riskAversion, AlgoParam.forceCompletion),
        DarkIce(AlgoParam.startTime, AlgoParam.endTime, AlgoParam.allowPastEndTime, AlgoParam.displaySize),
        PctVol(AlgoParam.startTime, AlgoParam.endTime, AlgoParam.pctVol, AlgoParam.noTakeLiq),
        AD(AlgoParam.startTime, AlgoParam.endTime, AlgoParam.componentSize, AlgoParam.timeBetweenOrders, AlgoParam.randomizeTime20, AlgoParam.randomizeSize55, AlgoParam.giveUp, AlgoParam.catchUp, AlgoParam.waitForFill);

        private AlgoParam[] m_params;

        public AlgoParam[] params() {
            return this.m_params;
        }

        private AlgoStrategy(AlgoParam ... params) {
            this.m_params = params;
        }

        public static AlgoStrategy get(String apiString) {
            return (AlgoStrategy)Types.getValueOf((String)apiString, (Enum[])AlgoStrategy.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this == None ? "" : super.toString();
        }
    }

    public static enum AlgoParam {
        startTime,
        endTime,
        allowPastEndTime,
        maxPctVol,
        pctVol,
        strategyType,
        noTakeLiq,
        riskAversion,
        forceCompletion,
        displaySize,
        getDone,
        noTradeAhead,
        useOddLots,
        componentSize,
        timeBetweenOrders,
        randomizeTime20,
        randomizeSize55,
        giveUp,
        catchUp,
        waitForFill;

    }

    public static enum ComboParam {
        NonGuaranteed,
        PriceCondConid,
        CondPriceMax,
        CondPriceMin,
        ChangeToMktTime1,
        ChangeToMktTime2,
        DiscretionaryPct,
        DontLeginNext,
        LeginPrio,
        MaxSegSize;

    }
}

