/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

public enum TickType {
    BID_SIZE(0, "bidSize"),
    BID(1, "bidPrice"),
    ASK(2, "askPrice"),
    ASK_SIZE(3, "askSize"),
    LAST(4, "lastPrice"),
    LAST_SIZE(5, "lastSize"),
    HIGH(6, "high"),
    LOW(7, "low"),
    VOLUME(8, "volume"),
    CLOSE(9, "close"),
    BID_OPTION(10, "bidOptComp"),
    ASK_OPTION(11, "askOptComp"),
    LAST_OPTION(12, "lastOptComp"),
    MODEL_OPTION(13, "modelOptComp"),
    OPEN(14, "open"),
    LOW_13_WEEK(15, "13WeekLow"),
    HIGH_13_WEEK(16, "13WeekHigh"),
    LOW_26_WEEK(17, "26WeekLow"),
    HIGH_26_WEEK(18, "26WeekHigh"),
    LOW_52_WEEK(19, "52WeekLow"),
    HIGH_52_WEEK(20, "52WeekHigh"),
    AVG_VOLUME(21, "AvgVolume"),
    OPEN_INTEREST(22, "OpenInterest"),
    OPTION_HISTORICAL_VOL(23, "OptionHistoricalVolatility"),
    OPTION_IMPLIED_VOL(24, "OptionImpliedVolatility"),
    OPTION_BID_EXCH(25, "OptionBidExchStr"),
    OPTION_ASK_EXCH(26, "OptionAskExchStr"),
    OPTION_CALL_OPEN_INTEREST(27, "OptionCallOpenInterest"),
    OPTION_PUT_OPEN_INTEREST(28, "OptionPutOpenInterest"),
    OPTION_CALL_VOLUME(29, "OptionCallVolume"),
    OPTION_PUT_VOLUME(30, "OptionPutVolume"),
    INDEX_FUTURE_PREMIUM(31, "IndexFuturePremium"),
    BID_EXCH(32, "bidExch"),
    ASK_EXCH(33, "askExch"),
    AUCTION_VOLUME(34, "auctionVolume"),
    AUCTION_PRICE(35, "auctionPrice"),
    AUCTION_IMBALANCE(36, "auctionImbalance"),
    MARK_PRICE(37, "markPrice"),
    BID_EFP_COMPUTATION(38, "bidEFP"),
    ASK_EFP_COMPUTATION(39, "askEFP"),
    LAST_EFP_COMPUTATION(40, "lastEFP"),
    OPEN_EFP_COMPUTATION(41, "openEFP"),
    HIGH_EFP_COMPUTATION(42, "highEFP"),
    LOW_EFP_COMPUTATION(43, "lowEFP"),
    CLOSE_EFP_COMPUTATION(44, "closeEFP"),
    LAST_TIMESTAMP(45, "lastTimestamp"),
    SHORTABLE(46, "shortable"),
    FUNDAMENTAL_RATIOS(47, "fundamentals"),
    RT_VOLUME(48, "RTVolume"),
    HALTED(49, "halted"),
    BID_YIELD(50, "bidYield"),
    ASK_YIELD(51, "askYield"),
    LAST_YIELD(52, "lastYield"),
    CUST_OPTION_COMPUTATION(53, "custOptComp"),
    TRADE_COUNT(54, "trades"),
    TRADE_RATE(55, "trades/min"),
    VOLUME_RATE(56, "volume/min"),
    LAST_RTH_TRADE(57, "lastRTHTrade"),
    RT_HISTORICAL_VOL(58, "RTHistoricalVol"),
    REGULATORY_IMBALANCE(61, "regulatoryImbalance"),
    UNKNOWN(Integer.MAX_VALUE, "unknown");

    private int m_ndx;
    private String m_field;

    public int index() {
        return this.m_ndx;
    }

    public String field() {
        return this.m_field;
    }

    private TickType(int ndx, String field) {
        this.m_ndx = ndx;
        this.m_field = field;
    }

    public static TickType get(int ndx) {
        for (TickType tt : TickType.values()) {
            if (tt.m_ndx != ndx) continue;
            return tt;
        }
        return UNKNOWN;
    }

    public static String getField(int tickType) {
        return TickType.get(tickType).field();
    }
}

