/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.ComboLeg;
import com.ib.client.CommissionReport;
import com.ib.client.Contract;
import com.ib.client.ContractDetails;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.EClientErrors;
import com.ib.client.EClientMsgSink;
import com.ib.client.EMessage;
import com.ib.client.EWrapper;
import com.ib.client.Execution;
import com.ib.client.Order;
import com.ib.client.OrderComboLeg;
import com.ib.client.OrderState;
import com.ib.client.TagValue;
import com.ib.client.TickType;
import com.ib.client.Util;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

class EDecoder {
    static final int END_CONN = -1;
    static final int TICK_PRICE = 1;
    static final int TICK_SIZE = 2;
    static final int ORDER_STATUS = 3;
    static final int ERR_MSG = 4;
    static final int OPEN_ORDER = 5;
    static final int ACCT_VALUE = 6;
    static final int PORTFOLIO_VALUE = 7;
    static final int ACCT_UPDATE_TIME = 8;
    static final int NEXT_VALID_ID = 9;
    static final int CONTRACT_DATA = 10;
    static final int EXECUTION_DATA = 11;
    static final int MARKET_DEPTH = 12;
    static final int MARKET_DEPTH_L2 = 13;
    static final int NEWS_BULLETINS = 14;
    static final int MANAGED_ACCTS = 15;
    static final int RECEIVE_FA = 16;
    static final int HISTORICAL_DATA = 17;
    static final int BOND_CONTRACT_DATA = 18;
    static final int SCANNER_PARAMETERS = 19;
    static final int SCANNER_DATA = 20;
    static final int TICK_OPTION_COMPUTATION = 21;
    static final int TICK_GENERIC = 45;
    static final int TICK_STRING = 46;
    static final int TICK_EFP = 47;
    static final int CURRENT_TIME = 49;
    static final int REAL_TIME_BARS = 50;
    static final int FUNDAMENTAL_DATA = 51;
    static final int CONTRACT_DATA_END = 52;
    static final int OPEN_ORDER_END = 53;
    static final int ACCT_DOWNLOAD_END = 54;
    static final int EXECUTION_DATA_END = 55;
    static final int DELTA_NEUTRAL_VALIDATION = 56;
    static final int TICK_SNAPSHOT_END = 57;
    static final int MARKET_DATA_TYPE = 58;
    static final int COMMISSION_REPORT = 59;
    static final int POSITION = 61;
    static final int POSITION_END = 62;
    static final int ACCOUNT_SUMMARY = 63;
    static final int ACCOUNT_SUMMARY_END = 64;
    static final int VERIFY_MESSAGE_API = 65;
    static final int VERIFY_COMPLETED = 66;
    static final int DISPLAY_GROUP_LIST = 67;
    static final int DISPLAY_GROUP_UPDATED = 68;
    static final int VERIFY_AND_AUTH_MESSAGE_API = 69;
    static final int VERIFY_AND_AUTH_COMPLETED = 70;
    static final int MAX_MSG_LENGTH = 0xFFFFFF;
    static final int REDIRECT_MSG_ID = -1;
    EClientMsgSink m_clientMsgSink;
    EWrapper m_EWrapper;
    int m_serverVersion;
    private IMessageReader m_messageReader;

    public EDecoder(int serverVersion, EWrapper callback) {
        this(serverVersion, callback, null);
    }

    public EDecoder(int serverVersion, EWrapper callback, EClientMsgSink sink) {
        this.m_clientMsgSink = sink;
        this.m_serverVersion = serverVersion;
        this.m_EWrapper = callback;
    }

    protected void processFirstMsg() throws IOException {
        this.m_serverVersion = this.readInt();
        if (this.m_serverVersion == -1) {
            String newAddress = this.readStr();
            this.m_serverVersion = 0;
            if (this.m_clientMsgSink != null) {
                this.m_clientMsgSink.redirect(newAddress);
            }
            return;
        }
        if (this.m_serverVersion >= 20) {
            String twsTime = this.readStr();
            if (this.m_clientMsgSink != null) {
                this.m_clientMsgSink.serverVersion(this.m_serverVersion, twsTime);
            }
        } else if (this.m_clientMsgSink != null) {
            this.m_clientMsgSink.serverVersion(this.m_serverVersion, null);
        }
        this.m_EWrapper.connectAck();
    }

    protected boolean readMessageToInternalBuf(InputStream dis) throws IOException {
        this.m_messageReader = new PreV100MessageReader(dis);
        return this.m_messageReader != null;
    }

    public int processMsg(EMessage msg) throws IOException {
        if (!this.readMessageToInternalBuf(msg.getStream())) {
            return 0;
        }
        if (this.m_serverVersion == 0) {
            this.processFirstMsg();
            return this.m_messageReader.msgLength();
        }
        int msgId = this.readInt();
        switch (msgId) {
            case -1: {
                return 0;
            }
            case 1: {
                this.processTickPriceMsg();
                break;
            }
            case 2: {
                this.processTickSizeMsg();
                break;
            }
            case 61: {
                this.processPositionMsg();
                break;
            }
            case 62: {
                this.processPositionEndMsg();
                break;
            }
            case 63: {
                this.processAccountSummaryMsg();
                break;
            }
            case 64: {
                this.processAccountSummaryEndMsg();
                break;
            }
            case 21: {
                this.processTickOptionComputatioMsg();
                break;
            }
            case 45: {
                this.processTickGenericMsg();
                break;
            }
            case 46: {
                this.processTickStringMsg();
                break;
            }
            case 47: {
                this.processTickEFPMsg();
                break;
            }
            case 3: {
                this.processOrderStatusMsg();
                break;
            }
            case 6: {
                this.processAcctValueMsg();
                break;
            }
            case 7: {
                this.processPortfolioValueMsg();
                break;
            }
            case 8: {
                this.processAcctUpdateTimeMsg();
                break;
            }
            case 4: {
                this.processErrMsgMsg();
                break;
            }
            case 5: {
                this.processOpenOrderMsg();
                break;
            }
            case 9: {
                this.processNextValidIdMsg();
                break;
            }
            case 20: {
                this.processScannerDataMsg();
                break;
            }
            case 10: {
                this.processContractDataMsg();
                break;
            }
            case 18: {
                this.processBondContractDataMsg();
                break;
            }
            case 11: {
                this.processExecutionDataMsg();
                break;
            }
            case 12: {
                this.processMarketDepthMsg();
                break;
            }
            case 13: {
                this.processMarketDepthL2Msg();
                break;
            }
            case 14: {
                this.processNewsBulletinsMsg();
                break;
            }
            case 15: {
                this.processManagedAcctsMsg();
                break;
            }
            case 16: {
                this.processReceiveFaMsg();
                break;
            }
            case 17: {
                this.processHistoricalDataMsg();
                break;
            }
            case 19: {
                this.processScannerParametersMsg();
                break;
            }
            case 49: {
                this.processCurrentTimeMsg();
                break;
            }
            case 50: {
                this.processRealTimeBarsMsg();
                break;
            }
            case 51: {
                this.processFundamentalDataMsg();
                break;
            }
            case 52: {
                this.processContractDataEndMsg();
                break;
            }
            case 53: {
                this.processOpenOrderEndMsg();
                break;
            }
            case 54: {
                this.processAcctDownloadEndMsg();
                break;
            }
            case 55: {
                this.processExecutionDataEndMsg();
                break;
            }
            case 56: {
                this.processDeltaNetrualValidationMsg();
                break;
            }
            case 57: {
                this.processTickSnapshotEndMsg();
                break;
            }
            case 58: {
                this.processMarketDataTypeMsg();
                break;
            }
            case 59: {
                this.processCommissionReportMsg();
                break;
            }
            case 65: {
                this.processVerifyMessageApiMsg();
                break;
            }
            case 66: {
                this.processVerivyCompletedMsg();
                break;
            }
            case 67: {
                this.processDisplayGroupListMsg();
                break;
            }
            case 68: {
                this.processDisplayGroupUpdatedMsg();
                break;
            }
            case 69: {
                this.processVerifyAndAuthMessageMsg();
                break;
            }
            case 70: {
                this.processVerifyAndAuthCompletedMsg();
                break;
            }
            default: {
                this.m_EWrapper.error(-1, EClientErrors.UNKNOWN_ID.code(), EClientErrors.UNKNOWN_ID.msg());
                return 0;
            }
        }
        this.m_messageReader.close();
        return this.m_messageReader.msgLength();
    }

    private void processVerifyAndAuthCompletedMsg() throws IOException {
        this.readInt();
        String isSuccessfulStr = this.readStr();
        boolean isSuccessful = "true".equals(isSuccessfulStr);
        String errorText = this.readStr();
        this.m_EWrapper.verifyAndAuthCompleted(isSuccessful, errorText);
    }

    private void processVerifyAndAuthMessageMsg() throws IOException {
        this.readInt();
        String apiData = this.readStr();
        String xyzChallenge = this.readStr();
        this.m_EWrapper.verifyAndAuthMessageAPI(apiData, xyzChallenge);
    }

    private void processDisplayGroupUpdatedMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        String contractInfo = this.readStr();
        this.m_EWrapper.displayGroupUpdated(reqId, contractInfo);
    }

    private void processDisplayGroupListMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        String groups = this.readStr();
        this.m_EWrapper.displayGroupList(reqId, groups);
    }

    private void processVerivyCompletedMsg() throws IOException {
        this.readInt();
        String isSuccessfulStr = this.readStr();
        boolean isSuccessful = "true".equals(isSuccessfulStr);
        String errorText = this.readStr();
        this.m_EWrapper.verifyCompleted(isSuccessful, errorText);
    }

    private void processVerifyMessageApiMsg() throws IOException {
        this.readInt();
        String apiData = this.readStr();
        this.m_EWrapper.verifyMessageAPI(apiData);
    }

    private void processCommissionReportMsg() throws IOException {
        this.readInt();
        CommissionReport commissionReport = new CommissionReport();
        commissionReport.m_execId = this.readStr();
        commissionReport.m_commission = this.readDouble();
        commissionReport.m_currency = this.readStr();
        commissionReport.m_realizedPNL = this.readDouble();
        commissionReport.m_yield = this.readDouble();
        commissionReport.m_yieldRedemptionDate = this.readInt();
        this.m_EWrapper.commissionReport(commissionReport);
    }

    private void processMarketDataTypeMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        int marketDataType = this.readInt();
        this.m_EWrapper.marketDataType(reqId, marketDataType);
    }

    private void processTickSnapshotEndMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        this.m_EWrapper.tickSnapshotEnd(reqId);
    }

    private void processDeltaNetrualValidationMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        DeltaNeutralContract underComp = new DeltaNeutralContract(this.readInt(), this.readDouble(), this.readDouble());
        this.m_EWrapper.deltaNeutralValidation(reqId, underComp);
    }

    private void processExecutionDataEndMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        this.m_EWrapper.execDetailsEnd(reqId);
    }

    private void processAcctDownloadEndMsg() throws IOException {
        this.readInt();
        String accountName = this.readStr();
        this.m_EWrapper.accountDownloadEnd(accountName);
    }

    private void processOpenOrderEndMsg() throws IOException {
        this.readInt();
        this.m_EWrapper.openOrderEnd();
    }

    private void processContractDataEndMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        this.m_EWrapper.contractDetailsEnd(reqId);
    }

    private void processFundamentalDataMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        String data = this.readStr();
        this.m_EWrapper.fundamentalData(reqId, data);
    }

    private void processRealTimeBarsMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        long time = this.readLong();
        double open = this.readDouble();
        double high = this.readDouble();
        double low = this.readDouble();
        double close = this.readDouble();
        long volume = this.readLong();
        double wap = this.readDouble();
        int count = this.readInt();
        this.m_EWrapper.realtimeBar(reqId, time, open, high, low, close, volume, wap, count);
    }

    private void processCurrentTimeMsg() throws IOException {
        this.readInt();
        long time = this.readLong();
        this.m_EWrapper.currentTime(time);
    }

    private void processScannerParametersMsg() throws IOException {
        int version = this.readInt();
        String xml = this.readStr();
        this.m_EWrapper.scannerParameters(xml);
    }

    private void processHistoricalDataMsg() throws IOException {
        int version = this.readInt();
        int reqId = this.readInt();
        String completedIndicator = "finished";
        if (version >= 2) {
            String startDateStr = this.readStr();
            String endDateStr = this.readStr();
            completedIndicator = completedIndicator + "-" + startDateStr + "-" + endDateStr;
        }
        int itemCount = this.readInt();
        for (int ctr = 0; ctr < itemCount; ++ctr) {
            String date = this.readStr();
            double open = this.readDouble();
            double high = this.readDouble();
            double low = this.readDouble();
            double close = this.readDouble();
            int volume = this.readInt();
            double WAP = this.readDouble();
            String hasGaps = this.readStr();
            int barCount = -1;
            if (version >= 3) {
                barCount = this.readInt();
            }
            this.m_EWrapper.historicalData(reqId, date, open, high, low, close, volume, barCount, WAP, Boolean.valueOf(hasGaps));
        }
        this.m_EWrapper.historicalData(reqId, completedIndicator, -1.0, -1.0, -1.0, -1.0, -1, -1, -1.0, false);
    }

    private void processReceiveFaMsg() throws IOException {
        int version = this.readInt();
        int faDataType = this.readInt();
        String xml = this.readStr();
        this.m_EWrapper.receiveFA(faDataType, xml);
    }

    private void processManagedAcctsMsg() throws IOException {
        int version = this.readInt();
        String accountsList = this.readStr();
        this.m_EWrapper.managedAccounts(accountsList);
    }

    private void processNewsBulletinsMsg() throws IOException {
        int version = this.readInt();
        int newsMsgId = this.readInt();
        int newsMsgType = this.readInt();
        String newsMessage = this.readStr();
        String originatingExch = this.readStr();
        this.m_EWrapper.updateNewsBulletin(newsMsgId, newsMsgType, newsMessage, originatingExch);
    }

    private void processMarketDepthL2Msg() throws IOException {
        int version = this.readInt();
        int id = this.readInt();
        int position = this.readInt();
        String marketMaker = this.readStr();
        int operation = this.readInt();
        int side = this.readInt();
        double price = this.readDouble();
        int size = this.readInt();
        this.m_EWrapper.updateMktDepthL2(id, position, marketMaker, operation, side, price, size);
    }

    private void processMarketDepthMsg() throws IOException {
        int version = this.readInt();
        int id = this.readInt();
        int position = this.readInt();
        int operation = this.readInt();
        int side = this.readInt();
        double price = this.readDouble();
        int size = this.readInt();
        this.m_EWrapper.updateMktDepth(id, position, operation, side, price, size);
    }

    private void processExecutionDataMsg() throws IOException {
        int version = this.readInt();
        int reqId = -1;
        if (version >= 7) {
            reqId = this.readInt();
        }
        int orderId = this.readInt();
        Contract contract = new Contract();
        if (version >= 5) {
            contract.conid(this.readInt());
        }
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        if (version >= 9) {
            contract.multiplier(this.readStr());
        }
        contract.exchange(this.readStr());
        contract.currency(this.readStr());
        contract.localSymbol(this.readStr());
        if (version >= 10) {
            contract.tradingClass(this.readStr());
        }
        Execution exec = new Execution();
        exec.orderId(orderId);
        exec.execId(this.readStr());
        exec.time(this.readStr());
        exec.acctNumber(this.readStr());
        exec.exchange(this.readStr());
        exec.side(this.readStr());
        exec.shares(this.readInt());
        exec.price(this.readDouble());
        if (version >= 2) {
            exec.permId(this.readInt());
        }
        if (version >= 3) {
            exec.clientId(this.readInt());
        }
        if (version >= 4) {
            exec.liquidation(this.readInt());
        }
        if (version >= 6) {
            exec.cumQty(this.readInt());
            exec.avgPrice(this.readDouble());
        }
        if (version >= 8) {
            exec.orderRef(this.readStr());
        }
        if (version >= 9) {
            exec.evRule(this.readStr());
            exec.evMultiplier(this.readDouble());
        }
        this.m_EWrapper.execDetails(reqId, contract, exec);
    }

    private void processBondContractDataMsg() throws IOException {
        int secIdListCount;
        int version = this.readInt();
        int reqId = -1;
        if (version >= 3) {
            reqId = this.readInt();
        }
        ContractDetails contract = new ContractDetails();
        contract.contract().symbol(this.readStr());
        contract.contract().secType(this.readStr());
        contract.cusip(this.readStr());
        contract.coupon(this.readDouble());
        contract.maturity(this.readStr());
        contract.issueDate(this.readStr());
        contract.ratings(this.readStr());
        contract.bondType(this.readStr());
        contract.couponType(this.readStr());
        contract.convertible(this.readBoolFromInt());
        contract.callable(this.readBoolFromInt());
        contract.putable(this.readBoolFromInt());
        contract.descAppend(this.readStr());
        contract.contract().exchange(this.readStr());
        contract.contract().currency(this.readStr());
        contract.marketName(this.readStr());
        contract.contract().tradingClass(this.readStr());
        contract.contract().conid(this.readInt());
        contract.minTick(this.readDouble());
        contract.orderTypes(this.readStr());
        contract.validExchanges(this.readStr());
        if (version >= 2) {
            contract.nextOptionDate(this.readStr());
            contract.nextOptionType(this.readStr());
            contract.nextOptionPartial(this.readBoolFromInt());
            contract.notes(this.readStr());
        }
        if (version >= 4) {
            contract.longName(this.readStr());
        }
        if (version >= 6) {
            contract.evRule(this.readStr());
            contract.evMultiplier(this.readDouble());
        }
        if (version >= 5 && (secIdListCount = this.readInt()) > 0) {
            contract.secIdList(new ArrayList<TagValue>(secIdListCount));
            for (int i = 0; i < secIdListCount; ++i) {
                TagValue tagValue = new TagValue();
                tagValue.m_tag = this.readStr();
                tagValue.m_value = this.readStr();
                contract.secIdList().add(tagValue);
            }
        }
        this.m_EWrapper.bondContractDetails(reqId, contract);
    }

    private void processContractDataMsg() throws IOException {
        int secIdListCount;
        int version = this.readInt();
        int reqId = -1;
        if (version >= 3) {
            reqId = this.readInt();
        }
        ContractDetails contract = new ContractDetails();
        contract.contract().symbol(this.readStr());
        contract.contract().secType(this.readStr());
        contract.contract().lastTradeDateOrContractMonth(this.readStr());
        contract.contract().strike(this.readDouble());
        contract.contract().right(this.readStr());
        contract.contract().exchange(this.readStr());
        contract.contract().currency(this.readStr());
        contract.contract().localSymbol(this.readStr());
        contract.marketName(this.readStr());
        contract.contract().tradingClass(this.readStr());
        contract.contract().conid(this.readInt());
        contract.minTick(this.readDouble());
        contract.contract().multiplier(this.readStr());
        contract.orderTypes(this.readStr());
        contract.validExchanges(this.readStr());
        if (version >= 2) {
            contract.priceMagnifier(this.readInt());
        }
        if (version >= 4) {
            contract.underConid(this.readInt());
        }
        if (version >= 5) {
            contract.longName(this.readStr());
            contract.contract().primaryExch(this.readStr());
        }
        if (version >= 6) {
            contract.contractMonth(this.readStr());
            contract.industry(this.readStr());
            contract.category(this.readStr());
            contract.subcategory(this.readStr());
            contract.timeZoneId(this.readStr());
            contract.tradingHours(this.readStr());
            contract.liquidHours(this.readStr());
        }
        if (version >= 8) {
            contract.evRule(this.readStr());
            contract.evMultiplier(this.readDouble());
        }
        if (version >= 7 && (secIdListCount = this.readInt()) > 0) {
            contract.secIdList(new ArrayList<TagValue>(secIdListCount));
            for (int i = 0; i < secIdListCount; ++i) {
                TagValue tagValue = new TagValue();
                tagValue.m_tag = this.readStr();
                tagValue.m_value = this.readStr();
                contract.secIdList().add(tagValue);
            }
        }
        this.m_EWrapper.contractDetails(reqId, contract);
    }

    private void processScannerDataMsg() throws IOException {
        ContractDetails contract = new ContractDetails();
        int version = this.readInt();
        int tickerId = this.readInt();
        int numberOfElements = this.readInt();
        for (int ctr = 0; ctr < numberOfElements; ++ctr) {
            int rank = this.readInt();
            if (version >= 3) {
                contract.contract().conid(this.readInt());
            }
            contract.contract().symbol(this.readStr());
            contract.contract().secType(this.readStr());
            contract.contract().lastTradeDateOrContractMonth(this.readStr());
            contract.contract().strike(this.readDouble());
            contract.contract().right(this.readStr());
            contract.contract().exchange(this.readStr());
            contract.contract().currency(this.readStr());
            contract.contract().localSymbol(this.readStr());
            contract.marketName(this.readStr());
            contract.contract().tradingClass(this.readStr());
            String distance = this.readStr();
            String benchmark = this.readStr();
            String projection = this.readStr();
            String legsStr = null;
            if (version >= 2) {
                legsStr = this.readStr();
            }
            this.m_EWrapper.scannerData(tickerId, rank, contract, distance, benchmark, projection, legsStr);
        }
        this.m_EWrapper.scannerDataEnd(tickerId);
    }

    private void processNextValidIdMsg() throws IOException {
        int version = this.readInt();
        int orderId = this.readInt();
        this.m_EWrapper.nextValidId(orderId);
    }

    private void processOpenOrderMsg() throws IOException {
        int smartComboRoutingParamsCount;
        int i;
        int version = this.readInt();
        Order order = new Order();
        order.orderId(this.readInt());
        Contract contract = new Contract();
        if (version >= 17) {
            contract.conid(this.readInt());
        }
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        if (version >= 32) {
            contract.multiplier(this.readStr());
        }
        contract.exchange(this.readStr());
        contract.currency(this.readStr());
        if (version >= 2) {
            contract.localSymbol(this.readStr());
        }
        if (version >= 32) {
            contract.tradingClass(this.readStr());
        }
        order.action(this.readStr());
        order.totalQuantity(this.readInt());
        order.orderType(this.readStr());
        if (version < 29) {
            order.lmtPrice(this.readDouble());
        } else {
            order.lmtPrice(this.readDoubleMax());
        }
        if (version < 30) {
            order.auxPrice(this.readDouble());
        } else {
            order.auxPrice(this.readDoubleMax());
        }
        order.tif(this.readStr());
        order.ocaGroup(this.readStr());
        order.account(this.readStr());
        order.openClose(this.readStr());
        order.origin(this.readInt());
        order.orderRef(this.readStr());
        if (version >= 3) {
            order.clientId(this.readInt());
        }
        if (version >= 4) {
            order.permId(this.readInt());
            if (version < 18) {
                this.readBoolFromInt();
            } else {
                order.outsideRth(this.readBoolFromInt());
            }
            order.hidden(this.readInt() == 1);
            order.discretionaryAmt(this.readDouble());
        }
        if (version >= 5) {
            order.goodAfterTime(this.readStr());
        }
        if (version >= 6) {
            this.readStr();
        }
        if (version >= 7) {
            order.faGroup(this.readStr());
            order.faMethod(this.readStr());
            order.faPercentage(this.readStr());
            order.faProfile(this.readStr());
        }
        if (version >= 8) {
            order.goodTillDate(this.readStr());
        }
        if (version >= 9) {
            order.rule80A(this.readStr());
            order.percentOffset(this.readDoubleMax());
            order.settlingFirm(this.readStr());
            order.shortSaleSlot(this.readInt());
            order.designatedLocation(this.readStr());
            if (this.m_serverVersion == 51) {
                this.readInt();
            } else if (version >= 23) {
                order.exemptCode(this.readInt());
            }
            order.auctionStrategy(this.readInt());
            order.startingPrice(this.readDoubleMax());
            order.stockRefPrice(this.readDoubleMax());
            order.delta(this.readDoubleMax());
            order.stockRangeLower(this.readDoubleMax());
            order.stockRangeUpper(this.readDoubleMax());
            order.displaySize(this.readInt());
            if (version < 18) {
                this.readBoolFromInt();
            }
            order.blockOrder(this.readBoolFromInt());
            order.sweepToFill(this.readBoolFromInt());
            order.allOrNone(this.readBoolFromInt());
            order.minQty(this.readIntMax());
            order.ocaType(this.readInt());
            order.eTradeOnly(this.readBoolFromInt());
            order.firmQuoteOnly(this.readBoolFromInt());
            order.nbboPriceCap(this.readDoubleMax());
        }
        if (version >= 10) {
            order.parentId(this.readInt());
            order.triggerMethod(this.readInt());
        }
        if (version >= 11) {
            order.volatility(this.readDoubleMax());
            order.volatilityType(this.readInt());
            if (version == 11) {
                int receivedInt = this.readInt();
                order.deltaNeutralOrderType(receivedInt == 0 ? "NONE" : "MKT");
            } else {
                order.deltaNeutralOrderType(this.readStr());
                order.deltaNeutralAuxPrice(this.readDoubleMax());
                if (version >= 27 && !Util.StringIsEmpty(order.getDeltaNeutralOrderType())) {
                    order.deltaNeutralConId(this.readInt());
                    order.deltaNeutralSettlingFirm(this.readStr());
                    order.deltaNeutralClearingAccount(this.readStr());
                    order.deltaNeutralClearingIntent(this.readStr());
                }
                if (version >= 31 && !Util.StringIsEmpty(order.getDeltaNeutralOrderType())) {
                    order.deltaNeutralOpenClose(this.readStr());
                    order.deltaNeutralShortSale(this.readBoolFromInt());
                    order.deltaNeutralShortSaleSlot(this.readInt());
                    order.deltaNeutralDesignatedLocation(this.readStr());
                }
            }
            order.continuousUpdate(this.readInt());
            if (this.m_serverVersion == 26) {
                order.stockRangeLower(this.readDouble());
                order.stockRangeUpper(this.readDouble());
            }
            order.referencePriceType(this.readInt());
        }
        if (version >= 13) {
            order.trailStopPrice(this.readDoubleMax());
        }
        if (version >= 30) {
            order.trailingPercent(this.readDoubleMax());
        }
        if (version >= 14) {
            order.basisPoints(this.readDoubleMax());
            order.basisPointsType(this.readIntMax());
            contract.comboLegsDescrip(this.readStr());
        }
        if (version >= 29) {
            int orderComboLegsCount;
            int comboLegsCount = this.readInt();
            if (comboLegsCount > 0) {
                contract.comboLegs(new ArrayList<ComboLeg>(comboLegsCount));
                for (i = 0; i < comboLegsCount; ++i) {
                    int conId = this.readInt();
                    int ratio = this.readInt();
                    String action = this.readStr();
                    String exchange = this.readStr();
                    int openClose = this.readInt();
                    int shortSaleSlot = this.readInt();
                    String designatedLocation = this.readStr();
                    int exemptCode = this.readInt();
                    ComboLeg comboLeg = new ComboLeg(conId, ratio, action, exchange, openClose, shortSaleSlot, designatedLocation, exemptCode);
                    contract.comboLegs().add(comboLeg);
                }
            }
            if ((orderComboLegsCount = this.readInt()) > 0) {
                order.orderComboLegs(new ArrayList<OrderComboLeg>(orderComboLegsCount));
                for (int i2 = 0; i2 < orderComboLegsCount; ++i2) {
                    double price = this.readDoubleMax();
                    OrderComboLeg orderComboLeg = new OrderComboLeg(price);
                    order.orderComboLegs().add(orderComboLeg);
                }
            }
        }
        if (version >= 26 && (smartComboRoutingParamsCount = this.readInt()) > 0) {
            order.smartComboRoutingParams(new ArrayList<TagValue>(smartComboRoutingParamsCount));
            for (i = 0; i < smartComboRoutingParamsCount; ++i) {
                TagValue tagValue = new TagValue();
                tagValue.m_tag = this.readStr();
                tagValue.m_value = this.readStr();
                order.smartComboRoutingParams().add(tagValue);
            }
        }
        if (version >= 15) {
            if (version >= 20) {
                order.scaleInitLevelSize(this.readIntMax());
                order.scaleSubsLevelSize(this.readIntMax());
            } else {
                this.readIntMax();
                order.scaleInitLevelSize(this.readIntMax());
            }
            order.scalePriceIncrement(this.readDoubleMax());
        }
        if (version >= 28 && order.scalePriceIncrement() > 0.0 && order.scalePriceIncrement() != Double.MAX_VALUE) {
            order.scalePriceAdjustValue(this.readDoubleMax());
            order.scalePriceAdjustInterval(this.readIntMax());
            order.scaleProfitOffset(this.readDoubleMax());
            order.scaleAutoReset(this.readBoolFromInt());
            order.scaleInitPosition(this.readIntMax());
            order.scaleInitFillQty(this.readIntMax());
            order.scaleRandomPercent(this.readBoolFromInt());
        }
        if (version >= 24) {
            order.hedgeType(this.readStr());
            if (!Util.StringIsEmpty(order.getHedgeType())) {
                order.hedgeParam(this.readStr());
            }
        }
        if (version >= 25) {
            order.optOutSmartRouting(this.readBoolFromInt());
        }
        if (version >= 19) {
            order.clearingAccount(this.readStr());
            order.clearingIntent(this.readStr());
        }
        if (version >= 22) {
            order.notHeld(this.readBoolFromInt());
        }
        if (version >= 20 && this.readBoolFromInt()) {
            DeltaNeutralContract underComp = new DeltaNeutralContract();
            underComp.conid(this.readInt());
            underComp.delta(this.readDouble());
            underComp.price(this.readDouble());
            contract.underComp(underComp);
        }
        if (version >= 21) {
            int algoParamsCount;
            order.algoStrategy(this.readStr());
            if (!Util.StringIsEmpty(order.getAlgoStrategy()) && (algoParamsCount = this.readInt()) > 0) {
                for (i = 0; i < algoParamsCount; ++i) {
                    TagValue tagValue = new TagValue();
                    tagValue.m_tag = this.readStr();
                    tagValue.m_value = this.readStr();
                    order.algoParams().add(tagValue);
                }
            }
        }
        if (version >= 33) {
            order.solicited(this.readBoolFromInt());
        }
        OrderState orderState = new OrderState();
        if (version >= 16) {
            order.whatIf(this.readBoolFromInt());
            orderState.status(this.readStr());
            orderState.initMargin(this.readStr());
            orderState.maintMargin(this.readStr());
            orderState.equityWithLoan(this.readStr());
            orderState.commission(this.readDoubleMax());
            orderState.minCommission(this.readDoubleMax());
            orderState.maxCommission(this.readDoubleMax());
            orderState.commissionCurrency(this.readStr());
            orderState.warningText(this.readStr());
        }
        if (version >= 34) {
            order.randomizeSize(this.readBoolFromInt());
            order.randomizePrice(this.readBoolFromInt());
        }
        this.m_EWrapper.openOrder(order.orderId(), contract, order, orderState);
    }

    private void processErrMsgMsg() throws IOException {
        int version = this.readInt();
        if (version < 2) {
            String msg = this.readStr();
            this.m_EWrapper.error(msg);
        } else {
            int id = this.readInt();
            int errorCode = this.readInt();
            String errorMsg = this.readStr();
            this.m_EWrapper.error(id, errorCode, errorMsg);
        }
    }

    private void processAcctUpdateTimeMsg() throws IOException {
        int version = this.readInt();
        String timeStamp = this.readStr();
        this.m_EWrapper.updateAccountTime(timeStamp);
    }

    private void processPortfolioValueMsg() throws IOException {
        int version = this.readInt();
        Contract contract = new Contract();
        if (version >= 6) {
            contract.conid(this.readInt());
        }
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        if (version >= 7) {
            contract.multiplier(this.readStr());
            contract.primaryExch(this.readStr());
        }
        contract.currency(this.readStr());
        if (version >= 2) {
            contract.localSymbol(this.readStr());
        }
        if (version >= 8) {
            contract.tradingClass(this.readStr());
        }
        int position = this.readInt();
        double marketPrice = this.readDouble();
        double marketValue = this.readDouble();
        double averageCost = 0.0;
        double unrealizedPNL = 0.0;
        double realizedPNL = 0.0;
        if (version >= 3) {
            averageCost = this.readDouble();
            unrealizedPNL = this.readDouble();
            realizedPNL = this.readDouble();
        }
        String accountName = null;
        if (version >= 4) {
            accountName = this.readStr();
        }
        if (version == 6 && this.m_serverVersion == 39) {
            contract.primaryExch(this.readStr());
        }
        this.m_EWrapper.updatePortfolio(contract, position, marketPrice, marketValue, averageCost, unrealizedPNL, realizedPNL, accountName);
    }

    private void processAcctValueMsg() throws IOException {
        int version = this.readInt();
        String key = this.readStr();
        String val = this.readStr();
        String cur = this.readStr();
        String accountName = null;
        if (version >= 2) {
            accountName = this.readStr();
        }
        this.m_EWrapper.updateAccountValue(key, val, cur, accountName);
    }

    private void processOrderStatusMsg() throws IOException {
        int version = this.readInt();
        int id = this.readInt();
        String status = this.readStr();
        int filled = this.readInt();
        int remaining = this.readInt();
        double avgFillPrice = this.readDouble();
        int permId = 0;
        if (version >= 2) {
            permId = this.readInt();
        }
        int parentId = 0;
        if (version >= 3) {
            parentId = this.readInt();
        }
        double lastFillPrice = 0.0;
        if (version >= 4) {
            lastFillPrice = this.readDouble();
        }
        int clientId = 0;
        if (version >= 5) {
            clientId = this.readInt();
        }
        String whyHeld = null;
        if (version >= 6) {
            whyHeld = this.readStr();
        }
        this.m_EWrapper.orderStatus(id, status, filled, remaining, avgFillPrice, permId, parentId, lastFillPrice, clientId, whyHeld);
    }

    private void processTickEFPMsg() throws IOException {
        int version = this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        double basisPoints = this.readDouble();
        String formattedBasisPoints = this.readStr();
        double impliedFuturesPrice = this.readDouble();
        int holdDays = this.readInt();
        String futureLastTradeDate = this.readStr();
        double dividendImpact = this.readDouble();
        double dividendsToLastTradeDate = this.readDouble();
        this.m_EWrapper.tickEFP(tickerId, tickType, basisPoints, formattedBasisPoints, impliedFuturesPrice, holdDays, futureLastTradeDate, dividendImpact, dividendsToLastTradeDate);
    }

    private void processTickStringMsg() throws IOException {
        int version = this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        String value = this.readStr();
        this.m_EWrapper.tickString(tickerId, tickType, value);
    }

    private void processTickGenericMsg() throws IOException {
        int version = this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        double value = this.readDouble();
        this.m_EWrapper.tickGeneric(tickerId, tickType, value);
    }

    private void processTickOptionComputatioMsg() throws IOException {
        double delta;
        int version = this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        double impliedVol = this.readDouble();
        if (impliedVol < 0.0) {
            impliedVol = Double.MAX_VALUE;
        }
        if (Math.abs(delta = this.readDouble()) > 1.0) {
            delta = Double.MAX_VALUE;
        }
        double optPrice = Double.MAX_VALUE;
        double pvDividend = Double.MAX_VALUE;
        double gamma = Double.MAX_VALUE;
        double vega = Double.MAX_VALUE;
        double theta = Double.MAX_VALUE;
        double undPrice = Double.MAX_VALUE;
        if (version >= 6 || tickType == TickType.MODEL_OPTION.index()) {
            optPrice = this.readDouble();
            if (optPrice < 0.0) {
                optPrice = Double.MAX_VALUE;
            }
            if ((pvDividend = this.readDouble()) < 0.0) {
                pvDividend = Double.MAX_VALUE;
            }
        }
        if (version >= 6) {
            gamma = this.readDouble();
            if (Math.abs(gamma) > 1.0) {
                gamma = Double.MAX_VALUE;
            }
            if (Math.abs(vega = this.readDouble()) > 1.0) {
                vega = Double.MAX_VALUE;
            }
            if (Math.abs(theta = this.readDouble()) > 1.0) {
                theta = Double.MAX_VALUE;
            }
            if ((undPrice = this.readDouble()) < 0.0) {
                undPrice = Double.MAX_VALUE;
            }
        }
        this.m_EWrapper.tickOptionComputation(tickerId, tickType, impliedVol, delta, optPrice, pvDividend, gamma, vega, theta, undPrice);
    }

    private void processAccountSummaryEndMsg() throws IOException {
        int version = this.readInt();
        int reqId = this.readInt();
        this.m_EWrapper.accountSummaryEnd(reqId);
    }

    private void processAccountSummaryMsg() throws IOException {
        int version = this.readInt();
        int reqId = this.readInt();
        String account = this.readStr();
        String tag = this.readStr();
        String value = this.readStr();
        String currency = this.readStr();
        this.m_EWrapper.accountSummary(reqId, account, tag, value, currency);
    }

    private void processPositionEndMsg() throws IOException {
        int version = this.readInt();
        this.m_EWrapper.positionEnd();
    }

    private void processPositionMsg() throws IOException {
        int version = this.readInt();
        String account = this.readStr();
        Contract contract = new Contract();
        contract.conid(this.readInt());
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        contract.multiplier(this.readStr());
        contract.exchange(this.readStr());
        contract.currency(this.readStr());
        contract.localSymbol(this.readStr());
        if (version >= 2) {
            contract.tradingClass(this.readStr());
        }
        int pos = this.readInt();
        double avgCost = 0.0;
        if (version >= 3) {
            avgCost = this.readDouble();
        }
        this.m_EWrapper.position(account, contract, pos, avgCost);
    }

    private void processTickSizeMsg() throws IOException {
        int version = this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        int size = this.readInt();
        this.m_EWrapper.tickSize(tickerId, tickType, size);
    }

    private void processTickPriceMsg() throws IOException {
        int version = this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        double price = this.readDouble();
        int size = 0;
        if (version >= 2) {
            size = this.readInt();
        }
        int canAutoExecute = 0;
        if (version >= 3) {
            canAutoExecute = this.readInt();
        }
        this.m_EWrapper.tickPrice(tickerId, tickType, price, canAutoExecute);
        if (version >= 2) {
            int sizeTickType = -1;
            switch (tickType) {
                case 1: {
                    sizeTickType = 0;
                    break;
                }
                case 2: {
                    sizeTickType = 3;
                    break;
                }
                case 4: {
                    sizeTickType = 5;
                }
            }
            if (sizeTickType != -1) {
                this.m_EWrapper.tickSize(tickerId, sizeTickType, size);
            }
        }
    }

    protected String readStr() throws IOException {
        return this.m_messageReader.readStr();
    }

    boolean readBoolFromInt() throws IOException {
        String str = this.readStr();
        return str == null ? false : Integer.parseInt(str) != 0;
    }

    protected int readInt() throws IOException {
        String str = this.readStr();
        return str == null ? 0 : Integer.parseInt(str);
    }

    protected int readIntMax() throws IOException {
        String str = this.readStr();
        return str == null || str.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(str);
    }

    protected long readLong() throws IOException {
        String str = this.readStr();
        return str == null ? 0L : Long.parseLong(str);
    }

    protected double readDouble() throws IOException {
        String str = this.readStr();
        return str == null ? 0.0 : Double.parseDouble(str);
    }

    protected double readDoubleMax() throws IOException {
        String str = this.readStr();
        return str == null || str.length() == 0 ? Double.MAX_VALUE : Double.parseDouble(str);
    }

    private static class PreV100MessageReader
    implements IMessageReader {
        private final InputStream m_din;
        private int m_msgLength = 0;

        public PreV100MessageReader(InputStream din) {
            this.m_din = din;
        }

        @Override
        public int msgLength() {
            return this.m_msgLength;
        }

        @Override
        public String readStr() throws IOException {
            StringBuffer buf = new StringBuffer();
            while (true) {
                int c;
                if ((c = this.m_din.read()) <= 0) {
                    if (c < 0) {
                        throw new EOFException();
                    }
                    ++this.m_msgLength;
                    break;
                }
                buf.append((char)c);
                ++this.m_msgLength;
            }
            String str = buf.toString();
            return str.length() == 0 ? null : str;
        }

        @Override
        public void close() {
        }
    }

    private static interface IMessageReader
    extends Closeable {
        public String readStr() throws IOException;

        public int msgLength();
    }
}

