/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Builder;
import com.ib.client.EClient;
import com.ib.client.EClientErrors;
import com.ib.client.EClientMsgSink;
import com.ib.client.EMessage;
import com.ib.client.EReader;
import com.ib.client.EReaderSignal;
import com.ib.client.ESocket;
import com.ib.client.EWrapper;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;

public class EClientSocket
extends EClient
implements EClientMsgSink {
    protected int m_redirectCount = 0;
    protected int m_defaultPort;
    private boolean m_allowRedirect;
    protected DataInputStream m_dis;
    private boolean asyncEConnect;
    private boolean m_connected = false;
    private Socket m_socket;

    public void setAsyncEConnect(boolean asyncEConnect) {
        this.asyncEConnect = asyncEConnect;
    }

    public boolean isAsyncEConnect() {
        return this.asyncEConnect;
    }

    public EClientSocket(EWrapper eWrapper, EReaderSignal signal) {
        super(eWrapper, signal);
    }

    @Override
    protected Builder prepareBuffer() {
        Builder buf = new Builder(1024);
        if (this.m_useV100Plus) {
            buf.allocateLengthHeader();
        }
        return buf;
    }

    @Override
    protected void closeAndSend(Builder buf) throws IOException {
        if (this.m_useV100Plus) {
            buf.updateLength(0);
        }
        EMessage msg = new EMessage(buf);
        this.sendMsg(msg);
    }

    protected synchronized void eConnect(Socket socket) throws IOException {
        this.m_socketTransport = new ESocket(socket);
        this.m_dis = new DataInputStream(socket.getInputStream());
        this.m_defaultPort = socket.getPort();
        this.m_socket = socket;
        this.sendConnectRequest();
        EReader reader = new EReader(this, this.m_signal);
        if (this.m_useV100Plus) {
            reader.setUseV100Plus();
        }
        if (!this.asyncEConnect) {
            reader.putMessageToQueue();
            while (this.m_serverVersion == 0) {
                this.m_signal.waitForSignal();
                reader.processMsgs();
            }
        }
    }

    public synchronized void eConnect(Socket socket, int clientId) throws IOException {
        this.m_clientId = clientId;
        this.m_redirectCount = 0;
        this.eConnect(socket);
    }

    public synchronized void eConnect(String host, int port, int clientId) {
        this.eConnect(host, port, clientId, false);
    }

    public synchronized void eConnect(String host, int port, int clientId, boolean extraAuth) {
        this.m_host = this.checkConnected(host);
        this.m_clientId = clientId;
        this.m_extraAuth = extraAuth;
        this.m_redirectCount = 0;
        if (this.m_host == null) {
            return;
        }
        try {
            Socket socket = new Socket(this.m_host, port);
            this.eConnect(socket);
        }
        catch (Exception e) {
            this.eDisconnect();
            this.connectionError();
        }
    }

    public boolean allowRedirect() {
        return this.m_allowRedirect;
    }

    public void allowRedirect(boolean val) {
        this.m_allowRedirect = val;
    }

    @Override
    public void redirect(String newAddress) {
        if (this.m_useV100Plus) {
            if (!this.m_allowRedirect) {
                this.m_eWrapper.error(-1, EClientErrors.CONNECT_FAIL.code(), EClientErrors.CONNECT_FAIL.msg());
                return;
            }
            ++this.m_redirectCount;
            if (this.m_redirectCount > 2) {
                this.eDisconnect();
                this.m_eWrapper.error("Redirect count exceeded");
                return;
            }
            this.eDisconnect(false);
            try {
                this.performRedirect(newAddress, this.m_defaultPort);
            }
            catch (IOException e) {
                this.m_eWrapper.error(e);
            }
            return;
        }
    }

    @Override
    public void serverVersion(int version, String time) {
        this.m_serverVersion = version;
        this.m_TwsTime = time;
        if (this.m_useV100Plus && (this.m_serverVersion < 100 || this.m_serverVersion > 100)) {
            this.eDisconnect();
            this.m_eWrapper.error(-1, EClientErrors.UNSUPPORTED_VERSION.code(), EClientErrors.UNSUPPORTED_VERSION.msg());
            return;
        }
        if (this.m_serverVersion < 38) {
            this.eDisconnect();
            this.m_eWrapper.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        if (this.m_serverVersion >= 3 && this.m_serverVersion < 70) {
            try {
                this.send(this.m_clientId);
            }
            catch (IOException e) {
                this.m_eWrapper.error(e);
            }
        }
        this.m_connected = true;
    }

    protected void performRedirect(String address, int defaultPort) throws IOException {
        int newPort;
        System.out.println("Server Redirect: " + address);
        String[] array = address.split(":");
        this.m_host = array[0];
        try {
            newPort = array.length > 1 ? Integer.parseInt(array[1]) : defaultPort;
        }
        catch (NumberFormatException e) {
            System.out.println("Warning: redirect port is invalid, using default port");
            newPort = defaultPort;
        }
        this.eConnect(new Socket(this.m_host, newPort));
    }

    @Override
    public synchronized void eDisconnect() {
        this.eDisconnect(true);
    }

    private synchronized void eDisconnect(boolean resetState) {
        if (this.m_dis == null & this.m_socketTransport == null) {
            return;
        }
        if (resetState) {
            this.m_connected = false;
            this.m_extraAuth = false;
            this.m_clientId = -1;
            this.m_serverVersion = 0;
            this.m_TwsTime = "";
            this.m_redirectCount = 0;
        }
        DataInputStream dis = this.m_dis;
        this.m_dis = null;
        this.m_socketTransport = null;
        try {
            if (dis != null) {
                dis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return this.m_dis.read(buf, off, len);
    }

    public int readInt() throws IOException {
        return this.m_dis.readInt();
    }

    @Override
    public boolean isConnected() {
        return this.m_socket != null && this.m_socket.isConnected() && this.m_connected;
    }
}

