/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Builder;
import com.ib.client.ComboLeg;
import com.ib.client.Contract;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.EClientErrors;
import com.ib.client.EMessage;
import com.ib.client.EReaderSignal;
import com.ib.client.ETransport;
import com.ib.client.EWrapper;
import com.ib.client.ExecutionFilter;
import com.ib.client.Order;
import com.ib.client.OrderComboLeg;
import com.ib.client.ScannerSubscription;
import com.ib.client.TagValue;
import com.ib.client.Types;
import com.ib.client.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class EClient {
    public static final int MIN_VERSION = 100;
    public static final int MAX_VERSION = 100;
    protected static final int REDIRECT_COUNT_MAX = 2;
    protected static final int CLIENT_VERSION = 66;
    protected static final int MIN_SERVER_VER_SUPPORTED = 38;
    public static final int GROUPS = 1;
    public static final int PROFILES = 2;
    public static final int ALIASES = 3;
    private static final int REQ_MKT_DATA = 1;
    private static final int CANCEL_MKT_DATA = 2;
    protected static final int PLACE_ORDER = 3;
    private static final int CANCEL_ORDER = 4;
    private static final int REQ_OPEN_ORDERS = 5;
    private static final int REQ_ACCOUNT_DATA = 6;
    private static final int REQ_EXECUTIONS = 7;
    private static final int REQ_IDS = 8;
    private static final int REQ_CONTRACT_DATA = 9;
    private static final int REQ_MKT_DEPTH = 10;
    private static final int CANCEL_MKT_DEPTH = 11;
    private static final int REQ_NEWS_BULLETINS = 12;
    private static final int CANCEL_NEWS_BULLETINS = 13;
    private static final int SET_SERVER_LOGLEVEL = 14;
    private static final int REQ_AUTO_OPEN_ORDERS = 15;
    private static final int REQ_ALL_OPEN_ORDERS = 16;
    private static final int REQ_MANAGED_ACCTS = 17;
    private static final int REQ_FA = 18;
    private static final int REPLACE_FA = 19;
    private static final int REQ_HISTORICAL_DATA = 20;
    private static final int EXERCISE_OPTIONS = 21;
    private static final int REQ_SCANNER_SUBSCRIPTION = 22;
    private static final int CANCEL_SCANNER_SUBSCRIPTION = 23;
    private static final int REQ_SCANNER_PARAMETERS = 24;
    private static final int CANCEL_HISTORICAL_DATA = 25;
    private static final int REQ_CURRENT_TIME = 49;
    private static final int REQ_REAL_TIME_BARS = 50;
    private static final int CANCEL_REAL_TIME_BARS = 51;
    private static final int REQ_FUNDAMENTAL_DATA = 52;
    private static final int CANCEL_FUNDAMENTAL_DATA = 53;
    private static final int REQ_CALC_IMPLIED_VOLAT = 54;
    private static final int REQ_CALC_OPTION_PRICE = 55;
    private static final int CANCEL_CALC_IMPLIED_VOLAT = 56;
    private static final int CANCEL_CALC_OPTION_PRICE = 57;
    private static final int REQ_GLOBAL_CANCEL = 58;
    private static final int REQ_MARKET_DATA_TYPE = 59;
    private static final int REQ_POSITIONS = 61;
    private static final int REQ_ACCOUNT_SUMMARY = 62;
    private static final int CANCEL_ACCOUNT_SUMMARY = 63;
    private static final int CANCEL_POSITIONS = 64;
    private static final int VERIFY_REQUEST = 65;
    private static final int VERIFY_MESSAGE = 66;
    private static final int QUERY_DISPLAY_GROUPS = 67;
    private static final int SUBSCRIBE_TO_GROUP_EVENTS = 68;
    private static final int UPDATE_DISPLAY_GROUP = 69;
    private static final int UNSUBSCRIBE_FROM_GROUP_EVENTS = 70;
    private static final int START_API = 71;
    private static final int VERIFY_AND_AUTH_REQUEST = 72;
    private static final int VERIFY_AND_AUTH_MESSAGE = 73;
    private static final int MIN_SERVER_VER_REAL_TIME_BARS = 34;
    private static final int MIN_SERVER_VER_SCALE_ORDERS = 35;
    private static final int MIN_SERVER_VER_SNAPSHOT_MKT_DATA = 35;
    private static final int MIN_SERVER_VER_SSHORT_COMBO_LEGS = 35;
    private static final int MIN_SERVER_VER_WHAT_IF_ORDERS = 36;
    private static final int MIN_SERVER_VER_CONTRACT_CONID = 37;
    private static final int MIN_SERVER_VER_PTA_ORDERS = 39;
    private static final int MIN_SERVER_VER_FUNDAMENTAL_DATA = 40;
    private static final int MIN_SERVER_VER_UNDER_COMP = 40;
    private static final int MIN_SERVER_VER_CONTRACT_DATA_CHAIN = 40;
    private static final int MIN_SERVER_VER_SCALE_ORDERS2 = 40;
    private static final int MIN_SERVER_VER_ALGO_ORDERS = 41;
    private static final int MIN_SERVER_VER_EXECUTION_DATA_CHAIN = 42;
    private static final int MIN_SERVER_VER_NOT_HELD = 44;
    private static final int MIN_SERVER_VER_SEC_ID_TYPE = 45;
    private static final int MIN_SERVER_VER_PLACE_ORDER_CONID = 46;
    private static final int MIN_SERVER_VER_REQ_MKT_DATA_CONID = 47;
    private static final int MIN_SERVER_VER_REQ_CALC_IMPLIED_VOLAT = 49;
    private static final int MIN_SERVER_VER_REQ_CALC_OPTION_PRICE = 50;
    private static final int MIN_SERVER_VER_CANCEL_CALC_IMPLIED_VOLAT = 50;
    private static final int MIN_SERVER_VER_CANCEL_CALC_OPTION_PRICE = 50;
    private static final int MIN_SERVER_VER_SSHORTX_OLD = 51;
    private static final int MIN_SERVER_VER_SSHORTX = 52;
    private static final int MIN_SERVER_VER_REQ_GLOBAL_CANCEL = 53;
    private static final int MIN_SERVER_VER_HEDGE_ORDERS = 54;
    private static final int MIN_SERVER_VER_REQ_MARKET_DATA_TYPE = 55;
    private static final int MIN_SERVER_VER_OPT_OUT_SMART_ROUTING = 56;
    private static final int MIN_SERVER_VER_SMART_COMBO_ROUTING_PARAMS = 57;
    private static final int MIN_SERVER_VER_DELTA_NEUTRAL_CONID = 58;
    private static final int MIN_SERVER_VER_SCALE_ORDERS3 = 60;
    private static final int MIN_SERVER_VER_ORDER_COMBO_LEGS_PRICE = 61;
    private static final int MIN_SERVER_VER_TRAILING_PERCENT = 62;
    protected static final int MIN_SERVER_VER_DELTA_NEUTRAL_OPEN_CLOSE = 66;
    private static final int MIN_SERVER_VER_ACCT_SUMMARY = 67;
    protected static final int MIN_SERVER_VER_TRADING_CLASS = 68;
    protected static final int MIN_SERVER_VER_SCALE_TABLE = 69;
    protected static final int MIN_SERVER_VER_LINKING = 70;
    protected static final int MIN_SERVER_VER_ALGO_ID = 71;
    protected static final int MIN_SERVER_VER_OPTIONAL_CAPABILITIES = 72;
    protected static final int MIN_SERVER_VER_ORDER_SOLICITED = 73;
    protected static final int MIN_SERVER_VER_LINKING_AUTH = 74;
    protected static final int MIN_SERVER_VER_PRIMARYEXCH = 75;
    protected static final int MIN_SERVER_VER_RANDOMIZE_SIZE_AND_PRICE = 76;
    protected EReaderSignal m_signal;
    protected EWrapper m_eWrapper;
    protected int m_serverVersion;
    protected String m_TwsTime;
    protected int m_clientId;
    protected boolean m_extraAuth;
    protected boolean m_useV100Plus;
    private String m_optionalCapabilities;
    private String m_connectOptions;
    protected String m_host;
    protected ETransport m_socketTransport;

    public static String faMsgTypeName(int faDataType) {
        switch (faDataType) {
            case 1: {
                return "GROUPS";
            }
            case 2: {
                return "PROFILES";
            }
            case 3: {
                return "ALIASES";
            }
        }
        return null;
    }

    public int serverVersion() {
        return this.m_serverVersion;
    }

    public String TwsConnectionTime() {
        return this.m_TwsTime;
    }

    public EWrapper wrapper() {
        return this.m_eWrapper;
    }

    public abstract boolean isConnected();

    protected synchronized void setExtraAuth(boolean extraAuth) {
        this.m_extraAuth = extraAuth;
    }

    public void OptionalCapabilities(String val) {
        this.m_optionalCapabilities = val;
    }

    public String OptionalCapabilities() {
        return this.m_optionalCapabilities;
    }

    public EClient(EWrapper eWrapper, EReaderSignal signal) {
        this.m_eWrapper = eWrapper;
        this.m_signal = signal;
        this.m_clientId = -1;
        this.m_extraAuth = false;
        this.m_optionalCapabilities = "";
        this.m_serverVersion = 0;
    }

    protected void sendConnectRequest() throws IOException {
        if (!this.m_useV100Plus || this.m_connectOptions == null) {
            this.send(66);
        } else {
            this.sendV100APIHeader();
        }
    }

    public void setUseV100Plus(String connectOptions) {
        if (this.isConnected()) {
            this.m_eWrapper.error(-1, EClientErrors.ALREADY_CONNECTED.code(), EClientErrors.ALREADY_CONNECTED.msg());
            return;
        }
        this.m_connectOptions = connectOptions;
        this.m_useV100Plus = true;
    }

    protected void connectionError() {
        this.m_eWrapper.error(-1, EClientErrors.CONNECT_FAIL.code(), EClientErrors.CONNECT_FAIL.msg());
    }

    protected String checkConnected(String host) {
        if (this.isConnected()) {
            this.m_eWrapper.error(-1, EClientErrors.ALREADY_CONNECTED.code(), EClientErrors.ALREADY_CONNECTED.msg());
            return null;
        }
        if (EClient.IsEmpty(host)) {
            host = "127.0.0.1";
        }
        return host;
    }

    public abstract void eDisconnect();

    public synchronized void startAPI() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        int VERSION = 2;
        try {
            Builder b = this.prepareBuffer();
            b.send(71);
            b.send(2);
            b.send(this.m_clientId);
            if (this.m_serverVersion >= 72) {
                b.send(this.m_optionalCapabilities);
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_STARTAPI, e.toString());
            this.close();
        }
    }

    public synchronized void cancelScannerSubscription(int tickerId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(23);
            b.send(1);
            b.send(tickerId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANSCANNER, e.toString());
            this.close();
        }
    }

    public synchronized void reqScannerParameters() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(24);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQSCANNERPARAMETERS, e.toString());
            this.close();
        }
    }

    public synchronized void reqScannerSubscription(int tickerId, ScannerSubscription subscription, ArrayList<TagValue> scannerSubscriptionOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        int VERSION = 4;
        try {
            Builder b = this.prepareBuffer();
            b.send(22);
            b.send(4);
            b.send(tickerId);
            b.sendMax(subscription.numberOfRows());
            b.send(subscription.instrument());
            b.send(subscription.locationCode());
            b.send(subscription.scanCode());
            b.sendMax(subscription.abovePrice());
            b.sendMax(subscription.belowPrice());
            b.sendMax(subscription.aboveVolume());
            b.sendMax(subscription.marketCapAbove());
            b.sendMax(subscription.marketCapBelow());
            b.send(subscription.moodyRatingAbove());
            b.send(subscription.moodyRatingBelow());
            b.send(subscription.spRatingAbove());
            b.send(subscription.spRatingBelow());
            b.send(subscription.maturityDateAbove());
            b.send(subscription.maturityDateBelow());
            b.sendMax(subscription.couponRateAbove());
            b.sendMax(subscription.couponRateBelow());
            b.send(subscription.excludeConvertible());
            if (this.m_serverVersion >= 25) {
                b.sendMax(subscription.averageOptionVolumeAbove());
                b.send(subscription.scannerSettingPairs());
            }
            if (this.m_serverVersion >= 27) {
                b.send(subscription.stockTypeFilter());
            }
            if (this.m_serverVersion >= 70) {
                int scannerSubscriptionOptionsCount;
                StringBuilder scannerSubscriptionOptionsStr = new StringBuilder();
                int n = scannerSubscriptionOptionsCount = scannerSubscriptionOptions == null ? 0 : scannerSubscriptionOptions.size();
                if (scannerSubscriptionOptionsCount > 0) {
                    for (int i = 0; i < scannerSubscriptionOptionsCount; ++i) {
                        TagValue tagValue = scannerSubscriptionOptions.get(i);
                        scannerSubscriptionOptionsStr.append(tagValue.m_tag);
                        scannerSubscriptionOptionsStr.append("=");
                        scannerSubscriptionOptionsStr.append(tagValue.m_value);
                        scannerSubscriptionOptionsStr.append(";");
                    }
                }
                b.send(scannerSubscriptionOptionsStr.toString());
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQSCANNER, e.toString());
            this.close();
        }
    }

    public synchronized void reqMktData(int tickerId, Contract contract, String genericTickList, boolean snapshot, List<TagValue> mktDataOptions) {
        if (!this.isConnected()) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 35 && snapshot) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support snapshot market data requests.");
            return;
        }
        if (this.m_serverVersion < 40 && contract.underComp() != null) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support delta-neutral orders.");
            return;
        }
        if (this.m_serverVersion < 47 && contract.conid() > 0) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support conId parameter.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty(contract.tradingClass())) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in reqMarketData.");
            return;
        }
        int VERSION = 11;
        try {
            Builder b = this.prepareBuffer();
            b.send(1);
            b.send(11);
            b.send(tickerId);
            if (this.m_serverVersion >= 47) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                b.send(contract.multiplier());
            }
            b.send(contract.exchange());
            if (this.m_serverVersion >= 14) {
                b.send(contract.primaryExch());
            }
            b.send(contract.currency());
            if (this.m_serverVersion >= 2) {
                b.send(contract.localSymbol());
            }
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 8 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (contract.comboLegs() == null) {
                    b.send(0);
                } else {
                    b.send(contract.comboLegs().size());
                    for (int i = 0; i < contract.comboLegs().size(); ++i) {
                        ComboLeg comboLeg = contract.comboLegs().get(i);
                        b.send(comboLeg.conid());
                        b.send(comboLeg.ratio());
                        b.send(comboLeg.getAction());
                        b.send(comboLeg.exchange());
                    }
                }
            }
            if (this.m_serverVersion >= 40) {
                if (contract.underComp() != null) {
                    DeltaNeutralContract underComp = contract.underComp();
                    b.send(true);
                    b.send(underComp.conid());
                    b.send(underComp.delta());
                    b.send(underComp.price());
                } else {
                    b.send(false);
                }
            }
            if (this.m_serverVersion >= 31) {
                b.send(genericTickList);
            }
            if (this.m_serverVersion >= 35) {
                b.send(snapshot);
            }
            if (this.m_serverVersion >= 70) {
                int mktDataOptionsCount;
                StringBuilder mktDataOptionsStr = new StringBuilder();
                int n = mktDataOptionsCount = mktDataOptions == null ? 0 : mktDataOptions.size();
                if (mktDataOptionsCount > 0) {
                    for (int i = 0; i < mktDataOptionsCount; ++i) {
                        TagValue tagValue = mktDataOptions.get(i);
                        mktDataOptionsStr.append(tagValue.m_tag);
                        mktDataOptionsStr.append("=");
                        mktDataOptionsStr.append(tagValue.m_value);
                        mktDataOptionsStr.append(";");
                    }
                }
                b.send(mktDataOptionsStr.toString());
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQMKT, e.toString());
            this.close();
        }
    }

    public synchronized void cancelHistoricalData(int tickerId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support historical data query cancellation.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(25);
            b.send(1);
            b.send(tickerId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANHISTDATA, e.toString());
            this.close();
        }
    }

    public void cancelRealTimeBars(int tickerId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 34) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support realtime bar data query cancellation.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(51);
            b.send(1);
            b.send(tickerId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANRTBARS, e.toString());
            this.close();
        }
    }

    public synchronized void reqHistoricalData(int tickerId, Contract contract, String endDateTime, String durationStr, String barSizeSetting, String whatToShow, int useRTH, int formatDate, List<TagValue> chartOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        int VERSION = 6;
        try {
            if (this.m_serverVersion < 16) {
                this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support historical data backfill.");
                return;
            }
            if (!(this.m_serverVersion >= 68 || EClient.IsEmpty(contract.tradingClass()) && contract.conid() <= 0)) {
                this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in reqHistroricalData.");
                return;
            }
            Builder b = this.prepareBuffer();
            b.send(20);
            b.send(6);
            b.send(tickerId);
            if (this.m_serverVersion >= 68) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            b.send(contract.multiplier());
            b.send(contract.exchange());
            b.send(contract.primaryExch());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 31) {
                b.send(contract.includeExpired() ? 1 : 0);
            }
            if (this.m_serverVersion >= 20) {
                b.send(endDateTime);
                b.send(barSizeSetting);
            }
            b.send(durationStr);
            b.send(useRTH);
            b.send(whatToShow);
            if (this.m_serverVersion > 16) {
                b.send(formatDate);
            }
            if (Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (contract.comboLegs() == null) {
                    b.send(0);
                } else {
                    b.send(contract.comboLegs().size());
                    for (int i = 0; i < contract.comboLegs().size(); ++i) {
                        ComboLeg comboLeg = contract.comboLegs().get(i);
                        b.send(comboLeg.conid());
                        b.send(comboLeg.ratio());
                        b.send(comboLeg.getAction());
                        b.send(comboLeg.exchange());
                    }
                }
            }
            if (this.m_serverVersion >= 70) {
                int chartOptionsCount;
                StringBuilder chartOptionsStr = new StringBuilder();
                int n = chartOptionsCount = chartOptions == null ? 0 : chartOptions.size();
                if (chartOptionsCount > 0) {
                    for (int i = 0; i < chartOptionsCount; ++i) {
                        TagValue tagValue = chartOptions.get(i);
                        chartOptionsStr.append(tagValue.m_tag);
                        chartOptionsStr.append("=");
                        chartOptionsStr.append(tagValue.m_value);
                        chartOptionsStr.append(";");
                    }
                }
                b.send(chartOptionsStr.toString());
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQHISTDATA, e.toString());
            this.close();
        }
    }

    public synchronized void reqRealTimeBars(int tickerId, Contract contract, int barSize, String whatToShow, boolean useRTH, ArrayList<TagValue> realTimeBarsOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 34) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support real time bars.");
            return;
        }
        if (!(this.m_serverVersion >= 68 || EClient.IsEmpty(contract.tradingClass()) && contract.conid() <= 0)) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in reqRealTimeBars.");
            return;
        }
        int VERSION = 3;
        try {
            Builder b = this.prepareBuffer();
            b.send(50);
            b.send(3);
            b.send(tickerId);
            if (this.m_serverVersion >= 68) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            b.send(contract.multiplier());
            b.send(contract.exchange());
            b.send(contract.primaryExch());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            b.send(barSize);
            b.send(whatToShow);
            b.send(useRTH);
            if (this.m_serverVersion >= 70) {
                int realTimeBarsOptionsCount;
                StringBuilder realTimeBarsOptionsStr = new StringBuilder();
                int n = realTimeBarsOptionsCount = realTimeBarsOptions == null ? 0 : realTimeBarsOptions.size();
                if (realTimeBarsOptionsCount > 0) {
                    for (int i = 0; i < realTimeBarsOptionsCount; ++i) {
                        TagValue tagValue = realTimeBarsOptions.get(i);
                        realTimeBarsOptionsStr.append(tagValue.m_tag);
                        realTimeBarsOptionsStr.append("=");
                        realTimeBarsOptionsStr.append(tagValue.m_value);
                        realTimeBarsOptionsStr.append(";");
                    }
                }
                b.send(realTimeBarsOptionsStr.toString());
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQRTBARS, e.toString());
            this.close();
        }
    }

    public synchronized void reqContractDetails(int reqId, Contract contract) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 4) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        if (!(this.m_serverVersion >= 45 || EClient.IsEmpty(contract.getSecIdType()) && EClient.IsEmpty(contract.secId()))) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support secIdType and secId parameters.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty(contract.tradingClass())) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in reqContractDetails.");
            return;
        }
        if (this.m_serverVersion < 70 && !EClient.IsEmpty(contract.primaryExch())) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support primaryExchange parameter in reqContractDetails.");
            return;
        }
        int VERSION = 8;
        try {
            Builder b = this.prepareBuffer();
            b.send(9);
            b.send(8);
            if (this.m_serverVersion >= 40) {
                b.send(reqId);
            }
            if (this.m_serverVersion >= 37) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                b.send(contract.multiplier());
            }
            if (this.m_serverVersion >= 75) {
                b.send(contract.exchange());
                b.send(contract.primaryExch());
            } else if (this.m_serverVersion >= 70) {
                if (!(EClient.IsEmpty(contract.primaryExch()) || contract.exchange() != "BEST" && contract.exchange() != "SMART")) {
                    b.send(contract.exchange() + ":" + contract.primaryExch());
                } else {
                    b.send(contract.exchange());
                }
            }
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 31) {
                b.send(contract.includeExpired());
            }
            if (this.m_serverVersion >= 45) {
                b.send(contract.getSecIdType());
                b.send(contract.secId());
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQCONTRACT, e.toString());
            this.close();
        }
    }

    public synchronized void reqMktDepth(int tickerId, Contract contract, int numRows, ArrayList<TagValue> mktDepthOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 6) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        if (!(this.m_serverVersion >= 68 || EClient.IsEmpty(contract.tradingClass()) && contract.conid() <= 0)) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in reqMktDepth.");
            return;
        }
        int VERSION = 5;
        try {
            Builder b = this.prepareBuffer();
            b.send(10);
            b.send(5);
            b.send(tickerId);
            if (this.m_serverVersion >= 68) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                b.send(contract.multiplier());
            }
            b.send(contract.exchange());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 19) {
                b.send(numRows);
            }
            if (this.m_serverVersion >= 70) {
                int mktDepthOptionsCount;
                StringBuilder mktDepthOptionsStr = new StringBuilder();
                int n = mktDepthOptionsCount = mktDepthOptions == null ? 0 : mktDepthOptions.size();
                if (mktDepthOptionsCount > 0) {
                    for (int i = 0; i < mktDepthOptionsCount; ++i) {
                        TagValue tagValue = mktDepthOptions.get(i);
                        mktDepthOptionsStr.append(tagValue.m_tag);
                        mktDepthOptionsStr.append("=");
                        mktDepthOptionsStr.append(tagValue.m_value);
                        mktDepthOptionsStr.append(";");
                    }
                }
                b.send(mktDepthOptionsStr.toString());
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQMKTDEPTH, e.toString());
            this.close();
        }
    }

    public synchronized void cancelMktData(int tickerId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(2);
            b.send(1);
            b.send(tickerId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANMKT, e.toString());
            this.close();
        }
    }

    public synchronized void cancelMktDepth(int tickerId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 6) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(11);
            b.send(1);
            b.send(tickerId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANMKTDEPTH, e.toString());
            this.close();
        }
    }

    public synchronized void exerciseOptions(int tickerId, Contract contract, int exerciseAction, int exerciseQuantity, String account, int override) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        int VERSION = 2;
        try {
            if (this.m_serverVersion < 21) {
                this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support options exercise from the API.");
                return;
            }
            if (!(this.m_serverVersion >= 68 || EClient.IsEmpty(contract.tradingClass()) && contract.conid() <= 0)) {
                this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in exerciseOptions.");
                return;
            }
            Builder b = this.prepareBuffer();
            b.send(21);
            b.send(2);
            b.send(tickerId);
            if (this.m_serverVersion >= 68) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            b.send(contract.multiplier());
            b.send(contract.exchange());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            b.send(exerciseAction);
            b.send(exerciseQuantity);
            b.send(account);
            b.send(override);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQMKT, e.toString());
            this.close();
        }
    }

    public synchronized void placeOrder(int id, Contract contract, Order order) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 35 && (order.scaleInitLevelSize() != Integer.MAX_VALUE || order.scalePriceIncrement() != Double.MAX_VALUE)) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support Scale orders.");
            return;
        }
        if (this.m_serverVersion < 35 && !contract.comboLegs().isEmpty()) {
            for (ComboLeg comboLeg : contract.comboLegs()) {
                if (comboLeg.shortSaleSlot() == 0 && EClient.IsEmpty(comboLeg.designatedLocation())) continue;
                this.error(id, EClientErrors.UPDATE_TWS, "  It does not support SSHORT flag for combo legs.");
                return;
            }
        }
        if (this.m_serverVersion < 36 && order.whatIf()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support what-if orders.");
            return;
        }
        if (this.m_serverVersion < 40 && contract.underComp() != null) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support delta-neutral orders.");
            return;
        }
        if (this.m_serverVersion < 40 && order.scaleSubsLevelSize() != Integer.MAX_VALUE) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support Subsequent Level Size for Scale orders.");
            return;
        }
        if (this.m_serverVersion < 41 && !EClient.IsEmpty(order.getAlgoStrategy())) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support algo orders.");
            return;
        }
        if (this.m_serverVersion < 44 && order.notHeld()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support notHeld parameter.");
            return;
        }
        if (!(this.m_serverVersion >= 45 || EClient.IsEmpty(contract.getSecIdType()) && EClient.IsEmpty(contract.secId()))) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support secIdType and secId parameters.");
            return;
        }
        if (this.m_serverVersion < 46 && contract.conid() > 0) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support conId parameter.");
            return;
        }
        if (this.m_serverVersion < 52 && order.exemptCode() != -1) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support exemptCode parameter.");
            return;
        }
        if (this.m_serverVersion < 52 && !contract.comboLegs().isEmpty()) {
            for (ComboLeg comboLeg : contract.comboLegs()) {
                if (comboLeg.exemptCode() == -1) continue;
                this.error(id, EClientErrors.UPDATE_TWS, "  It does not support exemptCode parameter.");
                return;
            }
        }
        if (this.m_serverVersion < 54 && !EClient.IsEmpty(order.getHedgeType())) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support hedge orders.");
            return;
        }
        if (this.m_serverVersion < 56 && order.optOutSmartRouting()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support optOutSmartRouting parameter.");
            return;
        }
        if (!(this.m_serverVersion >= 58 || order.deltaNeutralConId() <= 0 && EClient.IsEmpty(order.deltaNeutralSettlingFirm()) && EClient.IsEmpty(order.deltaNeutralClearingAccount()) && EClient.IsEmpty(order.deltaNeutralClearingIntent()))) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support deltaNeutral parameters: ConId, SettlingFirm, ClearingAccount, ClearingIntent");
            return;
        }
        if (!(this.m_serverVersion >= 66 || EClient.IsEmpty(order.deltaNeutralOpenClose()) && !order.deltaNeutralShortSale() && order.deltaNeutralShortSaleSlot() <= 0 && EClient.IsEmpty(order.deltaNeutralDesignatedLocation()))) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support deltaNeutral parameters: OpenClose, ShortSale, ShortSaleSlot, DesignatedLocation");
            return;
        }
        if (this.m_serverVersion < 60 && order.scalePriceIncrement() > 0.0 && order.scalePriceIncrement() != Double.MAX_VALUE && (order.scalePriceAdjustValue() != Double.MAX_VALUE || order.scalePriceAdjustInterval() != Integer.MAX_VALUE || order.scaleProfitOffset() != Double.MAX_VALUE || order.scaleAutoReset() || order.scaleInitPosition() != Integer.MAX_VALUE || order.scaleInitFillQty() != Integer.MAX_VALUE || order.scaleRandomPercent())) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support Scale order parameters: PriceAdjustValue, PriceAdjustInterval, ProfitOffset, AutoReset, InitPosition, InitFillQty and RandomPercent");
            return;
        }
        if (this.m_serverVersion < 61 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType()) && !order.orderComboLegs().isEmpty()) {
            for (OrderComboLeg orderComboLeg : order.orderComboLegs()) {
                if (orderComboLeg.price() == Double.MAX_VALUE) continue;
                this.error(id, EClientErrors.UPDATE_TWS, "  It does not support per-leg prices for order combo legs.");
                return;
            }
        }
        if (this.m_serverVersion < 62 && order.trailingPercent() != Double.MAX_VALUE) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support trailing percent parameter");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty(contract.tradingClass())) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameters in placeOrder.");
            return;
        }
        if (this.m_serverVersion < 71 && !EClient.IsEmpty(order.algoId())) {
            this.error(id, EClientErrors.UPDATE_TWS, " It does not support algoId parameter");
        }
        if (!(this.m_serverVersion >= 69 || EClient.IsEmpty(order.scaleTable()) && EClient.IsEmpty(order.activeStartTime()) && EClient.IsEmpty(order.activeStopTime()))) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support scaleTable, activeStartTime and activeStopTime parameters.");
            return;
        }
        if (this.m_serverVersion < 73 && order.solicited()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support order solicited parameter.");
            return;
        }
        int VERSION = this.m_serverVersion < 44 ? 27 : 45;
        try {
            Builder b = this.prepareBuffer();
            b.send(3);
            b.send(VERSION);
            b.send(id);
            if (this.m_serverVersion >= 46) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                b.send(contract.multiplier());
            }
            b.send(contract.exchange());
            if (this.m_serverVersion >= 14) {
                b.send(contract.primaryExch());
            }
            b.send(contract.currency());
            if (this.m_serverVersion >= 2) {
                b.send(contract.localSymbol());
            }
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 45) {
                b.send(contract.getSecIdType());
                b.send(contract.secId());
            }
            b.send(order.getAction());
            b.send(order.totalQuantity());
            b.send(order.getOrderType());
            if (this.m_serverVersion < 61) {
                b.send(order.lmtPrice() == Double.MAX_VALUE ? 0.0 : order.lmtPrice());
            } else {
                b.sendMax(order.lmtPrice());
            }
            if (this.m_serverVersion < 62) {
                b.send(order.auxPrice() == Double.MAX_VALUE ? 0.0 : order.auxPrice());
            } else {
                b.sendMax(order.auxPrice());
            }
            b.send(order.getTif());
            b.send(order.ocaGroup());
            b.send(order.account());
            b.send(order.openClose());
            b.send(order.origin());
            b.send(order.orderRef());
            b.send(order.transmit());
            if (this.m_serverVersion >= 4) {
                b.send(order.parentId());
            }
            if (this.m_serverVersion >= 5) {
                b.send(order.blockOrder());
                b.send(order.sweepToFill());
                b.send(order.displaySize());
                b.send(order.getTriggerMethod());
                if (this.m_serverVersion < 38) {
                    b.send(false);
                } else {
                    b.send(order.outsideRth());
                }
            }
            if (this.m_serverVersion >= 7) {
                b.send(order.hidden());
            }
            if (this.m_serverVersion >= 8 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (contract.comboLegs() == null) {
                    b.send(0);
                } else {
                    b.send(contract.comboLegs().size());
                    for (ComboLeg comboLeg : contract.comboLegs()) {
                        b.send(comboLeg.conid());
                        b.send(comboLeg.ratio());
                        b.send(comboLeg.getAction());
                        b.send(comboLeg.exchange());
                        b.send(comboLeg.getOpenClose());
                        if (this.m_serverVersion >= 35) {
                            b.send(comboLeg.shortSaleSlot());
                            b.send(comboLeg.designatedLocation());
                        }
                        if (this.m_serverVersion < 51) continue;
                        b.send(comboLeg.exemptCode());
                    }
                }
            }
            if (this.m_serverVersion >= 61 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (order.orderComboLegs() == null) {
                    b.send(0);
                } else {
                    b.send(order.orderComboLegs().size());
                    for (OrderComboLeg orderComboLeg : order.orderComboLegs()) {
                        b.sendMax(orderComboLeg.price());
                    }
                }
            }
            if (this.m_serverVersion >= 57 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                ArrayList<TagValue> smartComboRoutingParams = order.smartComboRoutingParams();
                int smartComboRoutingParamsCount = smartComboRoutingParams == null ? 0 : smartComboRoutingParams.size();
                b.send(smartComboRoutingParamsCount);
                if (smartComboRoutingParamsCount > 0) {
                    for (TagValue tagValue : smartComboRoutingParams) {
                        b.send(tagValue.m_tag);
                        b.send(tagValue.m_value);
                    }
                }
            }
            if (this.m_serverVersion >= 9) {
                b.send("");
            }
            if (this.m_serverVersion >= 10) {
                b.send(order.discretionaryAmt());
            }
            if (this.m_serverVersion >= 11) {
                b.send(order.goodAfterTime());
            }
            if (this.m_serverVersion >= 12) {
                b.send(order.goodTillDate());
            }
            if (this.m_serverVersion >= 13) {
                b.send(order.faGroup());
                b.send(order.getFaMethod());
                b.send(order.faPercentage());
                b.send(order.faProfile());
            }
            if (this.m_serverVersion >= 18) {
                b.send(order.shortSaleSlot());
                b.send(order.designatedLocation());
            }
            if (this.m_serverVersion >= 51) {
                b.send(order.exemptCode());
            }
            if (this.m_serverVersion >= 19) {
                b.send(order.getOcaType());
                if (this.m_serverVersion < 38) {
                    b.send(false);
                }
                b.send(order.getRule80A());
                b.send(order.settlingFirm());
                b.send(order.allOrNone());
                b.sendMax(order.minQty());
                b.sendMax(order.percentOffset());
                b.send(order.eTradeOnly());
                b.send(order.firmQuoteOnly());
                b.sendMax(order.nbboPriceCap());
                b.sendMax(order.auctionStrategy());
                b.sendMax(order.startingPrice());
                b.sendMax(order.stockRefPrice());
                b.sendMax(order.delta());
                double lower = this.m_serverVersion == 26 && order.getOrderType().equals("VOL") ? Double.MAX_VALUE : order.stockRangeLower();
                double upper = this.m_serverVersion == 26 && order.getOrderType().equals("VOL") ? Double.MAX_VALUE : order.stockRangeUpper();
                b.sendMax(lower);
                b.sendMax(upper);
            }
            if (this.m_serverVersion >= 22) {
                b.send(order.overridePercentageConstraints());
            }
            if (this.m_serverVersion >= 26) {
                b.sendMax(order.volatility());
                b.send(order.getVolatilityType());
                if (this.m_serverVersion < 28) {
                    b.send(order.getDeltaNeutralOrderType().equalsIgnoreCase("MKT"));
                } else {
                    b.send(order.getDeltaNeutralOrderType());
                    b.sendMax(order.deltaNeutralAuxPrice());
                    if (this.m_serverVersion >= 58 && !EClient.IsEmpty(order.getDeltaNeutralOrderType())) {
                        b.send(order.deltaNeutralConId());
                        b.send(order.deltaNeutralSettlingFirm());
                        b.send(order.deltaNeutralClearingAccount());
                        b.send(order.deltaNeutralClearingIntent());
                    }
                    if (this.m_serverVersion >= 66 && !EClient.IsEmpty(order.getDeltaNeutralOrderType())) {
                        b.send(order.deltaNeutralOpenClose());
                        b.send(order.deltaNeutralShortSale());
                        b.send(order.deltaNeutralShortSaleSlot());
                        b.send(order.deltaNeutralDesignatedLocation());
                    }
                }
                b.send(order.continuousUpdate());
                if (this.m_serverVersion == 26) {
                    double lower = order.getOrderType().equals("VOL") ? order.stockRangeLower() : Double.MAX_VALUE;
                    double upper = order.getOrderType().equals("VOL") ? order.stockRangeUpper() : Double.MAX_VALUE;
                    b.sendMax(lower);
                    b.sendMax(upper);
                }
                b.send(order.getReferencePriceType());
            }
            if (this.m_serverVersion >= 30) {
                b.sendMax(order.trailStopPrice());
            }
            if (this.m_serverVersion >= 62) {
                b.sendMax(order.trailingPercent());
            }
            if (this.m_serverVersion >= 35) {
                if (this.m_serverVersion >= 40) {
                    b.sendMax(order.scaleInitLevelSize());
                    b.sendMax(order.scaleSubsLevelSize());
                } else {
                    b.send("");
                    b.sendMax(order.scaleInitLevelSize());
                }
                b.sendMax(order.scalePriceIncrement());
            }
            if (this.m_serverVersion >= 60 && order.scalePriceIncrement() > 0.0 && order.scalePriceIncrement() != Double.MAX_VALUE) {
                b.sendMax(order.scalePriceAdjustValue());
                b.sendMax(order.scalePriceAdjustInterval());
                b.sendMax(order.scaleProfitOffset());
                b.send(order.scaleAutoReset());
                b.sendMax(order.scaleInitPosition());
                b.sendMax(order.scaleInitFillQty());
                b.send(order.scaleRandomPercent());
            }
            if (this.m_serverVersion >= 69) {
                b.send(order.scaleTable());
                b.send(order.activeStartTime());
                b.send(order.activeStopTime());
            }
            if (this.m_serverVersion >= 54) {
                b.send(order.getHedgeType());
                if (!EClient.IsEmpty(order.getHedgeType())) {
                    b.send(order.hedgeParam());
                }
            }
            if (this.m_serverVersion >= 56) {
                b.send(order.optOutSmartRouting());
            }
            if (this.m_serverVersion >= 39) {
                b.send(order.clearingAccount());
                b.send(order.clearingIntent());
            }
            if (this.m_serverVersion >= 44) {
                b.send(order.notHeld());
            }
            if (this.m_serverVersion >= 40) {
                if (contract.underComp() != null) {
                    DeltaNeutralContract underComp = contract.underComp();
                    b.send(true);
                    b.send(underComp.conid());
                    b.send(underComp.delta());
                    b.send(underComp.price());
                } else {
                    b.send(false);
                }
            }
            if (this.m_serverVersion >= 41) {
                b.send(order.getAlgoStrategy());
                if (!EClient.IsEmpty(order.getAlgoStrategy())) {
                    ArrayList<TagValue> algoParams = order.algoParams();
                    int algoParamsCount = algoParams.size();
                    b.send(algoParamsCount);
                    for (TagValue tagValue : algoParams) {
                        b.send(tagValue.m_tag);
                        b.send(tagValue.m_value);
                    }
                }
            }
            if (this.m_serverVersion >= 71) {
                b.send(order.algoId());
            }
            if (this.m_serverVersion >= 36) {
                b.send(order.whatIf());
            }
            if (this.m_serverVersion >= 70) {
                int orderMiscOptionsCount;
                StringBuilder orderMiscOptionsStr = new StringBuilder();
                ArrayList<TagValue> orderMiscOptions = order.orderMiscOptions();
                int n = orderMiscOptionsCount = orderMiscOptions == null ? 0 : orderMiscOptions.size();
                if (orderMiscOptionsCount > 0) {
                    for (TagValue tagValue : orderMiscOptions) {
                        orderMiscOptionsStr.append(tagValue.m_tag);
                        orderMiscOptionsStr.append("=");
                        orderMiscOptionsStr.append(tagValue.m_value);
                        orderMiscOptionsStr.append(";");
                    }
                }
                b.send(orderMiscOptionsStr.toString());
            }
            if (this.m_serverVersion >= 73) {
                b.send(order.solicited());
            }
            if (this.m_serverVersion >= 76) {
                b.send(order.randomizeSize());
                b.send(order.randomizePrice());
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(id, EClientErrors.FAIL_SEND_ORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqAccountUpdates(boolean subscribe, String acctCode) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        int VERSION = 2;
        try {
            Builder b = this.prepareBuffer();
            b.send(6);
            b.send(2);
            b.send(subscribe);
            if (this.m_serverVersion >= 9) {
                b.send(acctCode);
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_ACCT, e.toString());
            this.close();
        }
    }

    public synchronized void reqExecutions(int reqId, ExecutionFilter filter) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        int VERSION = 3;
        try {
            Builder b = this.prepareBuffer();
            b.send(7);
            b.send(3);
            if (this.m_serverVersion >= 42) {
                b.send(reqId);
            }
            if (this.m_serverVersion >= 9) {
                b.send(filter.clientId());
                b.send(filter.acctCode());
                b.send(filter.time());
                b.send(filter.symbol());
                b.send(filter.secType());
                b.send(filter.exchange());
                b.send(filter.side());
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_EXEC, e.toString());
            this.close();
        }
    }

    public synchronized void cancelOrder(int id) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(4);
            b.send(1);
            b.send(id);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(id, EClientErrors.FAIL_SEND_CORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqOpenOrders() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(5);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqIds(int numIds) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(8);
            b.send(1);
            b.send(numIds);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqNewsBulletins(boolean allMsgs) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(12);
            b.send(1);
            b.send(allMsgs);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, e.toString());
            this.close();
        }
    }

    public synchronized void cancelNewsBulletins() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(13);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, e.toString());
            this.close();
        }
    }

    public synchronized void setServerLogLevel(int logLevel) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(14);
            b.send(1);
            b.send(logLevel);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_SERVER_LOG_LEVEL, e.toString());
            this.close();
        }
    }

    public synchronized void reqAutoOpenOrders(boolean bAutoBind) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(15);
            b.send(1);
            b.send(bAutoBind);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqAllOpenOrders() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(16);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqManagedAccts() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(17);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, e.toString());
            this.close();
        }
    }

    public synchronized void requestFA(int faDataType) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 13) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(18);
            b.send(1);
            b.send(faDataType);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(faDataType, EClientErrors.FAIL_SEND_FA_REQUEST, e.toString());
            this.close();
        }
    }

    public synchronized void replaceFA(int faDataType, String xml) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 13) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(19);
            b.send(1);
            b.send(faDataType);
            b.send(xml);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(faDataType, EClientErrors.FAIL_SEND_FA_REPLACE, e.toString());
            this.close();
        }
    }

    public synchronized void reqCurrentTime() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 33) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support current time requests.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(49);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQCURRTIME, e.toString());
            this.close();
        }
    }

    public synchronized void reqFundamentalData(int reqId, Contract contract, String reportType) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 40) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support fundamental data requests.");
            return;
        }
        if (this.m_serverVersion < 68 && contract.conid() > 0) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support conId parameter in reqFundamentalData.");
            return;
        }
        int VERSION = 2;
        try {
            Builder b = this.prepareBuffer();
            b.send(52);
            b.send(2);
            b.send(reqId);
            if (this.m_serverVersion >= 68) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.exchange());
            b.send(contract.primaryExch());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            b.send(reportType);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQFUNDDATA, e.toString());
            this.close();
        }
    }

    public synchronized void cancelFundamentalData(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 40) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support fundamental data requests.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(53);
            b.send(1);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_CANFUNDDATA, e.toString());
            this.close();
        }
    }

    public synchronized void calculateImpliedVolatility(int reqId, Contract contract, double optionPrice, double underPrice) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 49) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support calculate implied volatility requests.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty(contract.tradingClass())) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in calculateImpliedVolatility.");
            return;
        }
        int VERSION = 2;
        try {
            Builder b = this.prepareBuffer();
            b.send(54);
            b.send(2);
            b.send(reqId);
            b.send(contract.conid());
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            b.send(contract.multiplier());
            b.send(contract.exchange());
            b.send(contract.primaryExch());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            b.send(optionPrice);
            b.send(underPrice);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQCALCIMPLIEDVOLAT, e.toString());
            this.close();
        }
    }

    public synchronized void cancelCalculateImpliedVolatility(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support calculate implied volatility cancellation.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(56);
            b.send(1);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_CANCALCIMPLIEDVOLAT, e.toString());
            this.close();
        }
    }

    public synchronized void calculateOptionPrice(int reqId, Contract contract, double volatility, double underPrice) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support calculate option price requests.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty(contract.tradingClass())) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in calculateOptionPrice.");
            return;
        }
        int VERSION = 2;
        try {
            Builder b = this.prepareBuffer();
            b.send(55);
            b.send(2);
            b.send(reqId);
            b.send(contract.conid());
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            b.send(contract.multiplier());
            b.send(contract.exchange());
            b.send(contract.primaryExch());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            b.send(volatility);
            b.send(underPrice);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQCALCOPTIONPRICE, e.toString());
            this.close();
        }
    }

    public synchronized void cancelCalculateOptionPrice(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support calculate option price cancellation.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(57);
            b.send(1);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_CANCALCOPTIONPRICE, e.toString());
            this.close();
        }
    }

    public synchronized void reqGlobalCancel() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 53) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support globalCancel requests.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(58);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQGLOBALCANCEL, e.toString());
            this.close();
        }
    }

    public synchronized void reqMarketDataType(int marketDataType) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 55) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support marketDataType requests.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(59);
            b.send(1);
            b.send(marketDataType);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQMARKETDATATYPE, e.toString());
            this.close();
        }
    }

    public synchronized void reqPositions() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support position requests.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(61);
        b.send(1);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQPOSITIONS, e.toString());
        }
    }

    public synchronized void cancelPositions() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support position cancellation.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(64);
        b.send(1);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_CANPOSITIONS, e.toString());
        }
    }

    public synchronized void reqAccountSummary(int reqId, String group, String tags) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support account summary requests.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(62);
        b.send(1);
        b.send(reqId);
        b.send(group);
        b.send(tags);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQACCOUNTDATA, e.toString());
        }
    }

    public synchronized void cancelAccountSummary(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support account summary cancellation.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(63);
        b.send(1);
        b.send(reqId);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_CANACCOUNTDATA, e.toString());
        }
    }

    public synchronized void verifyRequest(String apiName, String apiVersion) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification request.");
            return;
        }
        if (!this.m_extraAuth) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYMESSAGE, "  Intent to authenticate needs to be expressed during initial connect request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(65);
        b.send(1);
        b.send(apiName);
        b.send(apiVersion);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYREQUEST, e.toString());
        }
    }

    public synchronized void verifyMessage(String apiData) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification message sending.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(66);
        b.send(1);
        b.send(apiData);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYMESSAGE, e.toString());
        }
    }

    public synchronized void verifyAndAuthRequest(String apiName, String apiVersion, String opaqueIsvKey) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 74) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification request.");
            return;
        }
        if (!this.m_extraAuth) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYANDAUTHREQUEST, "  Intent to authenticate needs to be expressed during initial connect request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(72);
        b.send(1);
        b.send(apiName);
        b.send(apiVersion);
        b.send(opaqueIsvKey);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYANDAUTHREQUEST, e.toString());
        }
    }

    public synchronized void verifyAndAuthMessage(String apiData, String xyzResponse) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 74) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification message sending.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(73);
        b.send(1);
        b.send(apiData);
        b.send(xyzResponse);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYANDAUTHMESSAGE, e.toString());
        }
    }

    public synchronized void queryDisplayGroups(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support queryDisplayGroups request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(67);
        b.send(1);
        b.send(reqId);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_QUERYDISPLAYGROUPS, e.toString());
        }
    }

    public synchronized void subscribeToGroupEvents(int reqId, int groupId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support subscribeToGroupEvents request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(68);
        b.send(1);
        b.send(reqId);
        b.send(groupId);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_SUBSCRIBETOGROUPEVENTS, e.toString());
        }
    }

    public synchronized void updateDisplayGroup(int reqId, String contractInfo) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support updateDisplayGroup request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(69);
        b.send(1);
        b.send(reqId);
        b.send(contractInfo);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_UPDATEDISPLAYGROUP, e.toString());
        }
    }

    public synchronized void unsubscribeFromGroupEvents(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support unsubscribeFromGroupEvents request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        b.send(70);
        b.send(1);
        b.send(reqId);
        try {
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_UNSUBSCRIBEFROMGROUPEVENTS, e.toString());
        }
    }

    protected synchronized void error(String err) {
        this.m_eWrapper.error(err);
    }

    protected synchronized void error(int id, int errorCode, String errorMsg) {
        this.m_eWrapper.error(id, errorCode, errorMsg);
    }

    protected void close() {
        this.eDisconnect();
        this.wrapper().connectionClosed();
    }

    protected void error(int id, EClientErrors.CodeMsgPair pair, String tail) {
        this.error(id, pair.code(), pair.msg() + tail);
    }

    protected abstract Builder prepareBuffer();

    protected abstract void closeAndSend(Builder var1) throws IOException;

    private void sendV100APIHeader() throws IOException {
        Builder bos = new Builder(1024);
        bos.send("API\u0000".getBytes());
        String out = "v" + Integer.valueOf(100);
        if (!EClient.IsEmpty(this.m_connectOptions)) {
            out = out + " " + this.m_connectOptions;
        }
        int lengthPos = bos.allocateLengthHeader();
        bos.send(out.getBytes());
        bos.updateLength(lengthPos);
        this.sendMsg(new EMessage(bos));
    }

    protected void sendMsg(EMessage msg) throws IOException {
        this.m_socketTransport.send(msg);
    }

    private static boolean IsEmpty(String str) {
        return Util.StringIsEmpty(str);
    }

    protected void notConnected() {
        this.error(-1, EClientErrors.NOT_CONNECTED, "");
    }

    public String connectedHost() {
        return this.m_host;
    }

    protected void send(int val) throws IOException {
        this.send(String.valueOf(val));
    }

    protected void send(String str) throws IOException {
        Builder b = new Builder(1024);
        b.send(str);
        this.sendMsg(new EMessage(b));
    }
}

