/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.IApiEnum;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Builder {
    private static final char SEP = '\u0000';
    private static final int PADDING_SIZE = 1;
    private static final byte[] EMPTY_LENGTH_HEADER = new byte[4];
    private final ByteBuffer m_sb;

    public Builder(int size) {
        this.m_sb = new ByteBuffer(size);
    }

    public void send(int a) {
        this.send(String.valueOf(a));
    }

    public void sendMax(int a) {
        this.send(a == Integer.MAX_VALUE ? "" : String.valueOf(a));
    }

    public void send(double a) {
        this.send(String.valueOf(a));
    }

    public void sendMax(double a) {
        this.send(a == Double.MAX_VALUE ? "" : String.valueOf(a));
    }

    public void send(boolean a) {
        this.send(a ? 1 : 0);
    }

    public void send(IApiEnum a) {
        this.send(a == null ? (String)null : a.getApiString());
    }

    public void send(String a) {
        if (a != null) {
            byte[] buffer = a.getBytes();
            this.m_sb.write(buffer, 0, buffer.length);
        }
        this.m_sb.write(0);
    }

    public void send(byte[] bytes) {
        if (bytes != null) {
            this.m_sb.write(bytes, 0, bytes.length);
        }
    }

    public int allocateLengthHeader() {
        int lengthHeaderPosition = this.m_sb.size();
        this.m_sb.write(EMPTY_LENGTH_HEADER, 0, EMPTY_LENGTH_HEADER.length);
        return lengthHeaderPosition;
    }

    public void updateLength(int lengthHeaderPosition) {
        this.m_sb.updateLength(lengthHeaderPosition);
    }

    public void writeTo(DataOutputStream dos) throws IOException {
        this.m_sb.writeTo(dos);
    }

    public static void intToBytes(int val, byte[] b, int position) {
        b[position + 0] = (byte)(0xFF & val >> 24);
        b[position + 1] = (byte)(0xFF & val >> 16);
        b[position + 2] = (byte)(0xFF & val >> 8);
        b[position + 3] = (byte)(0xFF & val);
    }

    private static class ByteBuffer
    extends ByteArrayOutputStream {
        public ByteBuffer(int capacity) {
            super(capacity);
        }

        public void updateLength(int lengthHeaderPosition) {
            int len = this.count - EMPTY_LENGTH_HEADER.length - lengthHeaderPosition;
            Builder.intToBytes(len, this.buf, lengthHeaderPosition);
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.write(this.buf, 0, this.count);
        }
    }
}

