/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.tcp;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class TcpParameters {
    private InetAddress host = null;
    private int port;
    private boolean keepAlive;

    public TcpParameters() {
        try {
            this.setHost(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.setPort(502);
        this.setKeepAlive(true);
    }

    public TcpParameters(TcpParameters p) {
        this(p.getHost(), p.getPort(), p.isKeepAlive());
    }

    public TcpParameters(InetAddress host, int port, boolean keepAlive) {
        this.setHost(host);
        this.setPort(port);
        this.setKeepAlive(keepAlive);
    }

    public TcpParameters(String host, int port, boolean keepAlive) {
        try {
            this.setHost(InetAddress.getByName(host));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.setPort(port);
        this.setKeepAlive(keepAlive);
    }

    public InetAddress getHost() {
        return this.host;
    }

    public void setHost(InetAddress host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }
}

