/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.slave;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.net.ModbusConnectionFactory;
import com.intelligt.modbus.jlibmodbus.net.transport.ModbusTransport;
import com.intelligt.modbus.jlibmodbus.slave.ModbusSlaveTCP;
import com.intelligt.modbus.jlibmodbus.slave.RequestHandler;
import java.io.IOException;
import java.net.Socket;

class RequestHandlerTCP
extends RequestHandler {
    private final Socket socket;

    RequestHandlerTCP(ModbusSlaveTCP slave, Socket s) throws ModbusIOException {
        super(slave, ModbusConnectionFactory.getTcpSlave(s));
        this.socket = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setListening(true);
        try {
            this.getSlave().connectionOpened(this.getConnection());
            do {
                try {
                    DataHolder dataHolder = this.getSlave().getDataHolder();
                    ModbusTransport transport = this.getConnection().getTransport();
                    ModbusRequest request = (ModbusRequest)transport.readRequest();
                    if (request.getServerAddress() == 255 || request.getServerAddress() == this.getSlave().getServerAddress()) {
                        ModbusResponse response = request.process(dataHolder);
                        response.setTransactionId(request.getTransactionId());
                        if (request.getServerAddress() == 0) continue;
                        transport.send(response);
                        continue;
                    }
                    if (request.getServerAddress() != 0 || !this.getSlave().isBroadcastEnabled()) continue;
                    request.process(dataHolder);
                }
                catch (ModbusNumberException e) {
                    Modbus.log().warning(e.getLocalizedMessage());
                }
            } while (this.isListening());
        }
        catch (ModbusIOException e) {
            if (this.getSlave().isListening()) {
                Modbus.log().warning(e.getLocalizedMessage());
            }
        }
        finally {
            this.setListening(false);
            try {
                if (this.getConnection().isOpened()) {
                    this.getConnection().close();
                    this.getSlave().connectionClosed(this.getConnection());
                }
            }
            catch (ModbusIOException ioe) {
                Modbus.log().warning(ioe.getMessage());
            }
        }
    }

    @Override
    public void closeConnection() {
        try {
            if (this.socket.isConnected() && !this.isListening()) {
                this.socket.close();
                this.setListening(false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

