/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.slave;

import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.net.ModbusConnection;
import com.intelligt.modbus.jlibmodbus.serial.SerialParameters;
import com.intelligt.modbus.jlibmodbus.slave.ModbusSlave;
import com.intelligt.modbus.jlibmodbus.slave.RequestHandler;
import com.intelligt.modbus.jlibmodbus.slave.RequestHandlerSerial;
import com.intelligt.modbus.jlibmodbus.utils.FrameEvent;
import com.intelligt.modbus.jlibmodbus.utils.FrameEventListener;
import com.intelligt.modbus.jlibmodbus.utils.SerialPortInfo;

class ModbusSlaveSerial
extends ModbusSlave {
    private final ModbusConnection conn;
    private final RequestHandler requestHandler;
    private final SerialPortInfo serialPortInfo;
    private Thread mainThread = null;

    ModbusSlaveSerial(SerialParameters serialParameters, ModbusConnection conn) {
        this.conn = conn;
        this.serialPortInfo = new SerialPortInfo(serialParameters);
        this.requestHandler = new RequestHandlerSerial(this, conn);
    }

    @Override
    public synchronized void listenImpl() throws ModbusIOException {
        if (this.isListening()) {
            this.shutdown();
        }
        this.mainThread = new Thread(this.requestHandler);
        this.mainThread.start();
    }

    @Override
    public synchronized void shutdownImpl() throws ModbusIOException {
        this.requestHandler.closeConnection();
        try {
            if (this.mainThread != null) {
                this.mainThread.join(this.getReadTimeout() * 10);
                if (this.mainThread.isAlive()) {
                    this.mainThread.interrupt();
                }
            }
            this.mainThread = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected ModbusConnection getConnection() {
        return this.conn;
    }

    @Override
    void connectionOpened(ModbusConnection connection) {
        super.connectionOpened(connection);
        this.serialPortInfo.setOpened(true);
        this.notifyObservers(this.serialPortInfo);
    }

    @Override
    void connectionClosed(ModbusConnection connection) {
        super.connectionClosed(connection);
        this.serialPortInfo.setOpened(false);
        this.notifyObservers(this.serialPortInfo);
    }

    @Override
    public void addListener(FrameEventListener listener) {
        this.getConnection().addListener(listener);
    }

    @Override
    public void removeListener(FrameEventListener listener) {
        this.getConnection().removeListener(listener);
    }

    @Override
    public void removeListeners() {
        this.getConnection().removeListeners();
    }

    @Override
    public void fireFrameReceivedEvent(FrameEvent event) {
        this.getConnection().fireFrameReceivedEvent(event);
    }

    @Override
    public void fireFrameSentEvent(FrameEvent event) {
        this.fireFrameSentEvent(event);
    }

    @Override
    public int countListeners() {
        return this.getConnection().countListeners();
    }
}

