/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.slave;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.data.DataHolderBuilder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.net.ModbusConnection;
import com.intelligt.modbus.jlibmodbus.utils.FrameEvent;
import com.intelligt.modbus.jlibmodbus.utils.FrameEventListener;
import com.intelligt.modbus.jlibmodbus.utils.FrameEventListenerList;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ModbusSlave
implements FrameEventListenerList {
    private final List<ModbusConnection> connectionList = new ArrayList<ModbusConnection>();
    private final AtomicBoolean listening = new AtomicBoolean(false);
    private final AtomicBoolean broadcastEnabled = new AtomicBoolean(false);
    private Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };
    private int serverAddress = 0;
    private DataHolder dataHolder = new DataHolder();
    private volatile int readTimeout = 1000;

    protected ModbusSlave() {
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        for (ModbusConnection conn : this.getConnectionList()) {
            conn.setReadTimeout(readTimeout);
        }
    }

    protected abstract void listenImpl() throws ModbusIOException;

    protected abstract void shutdownImpl() throws ModbusIOException;

    public final void listen() throws ModbusIOException {
        this.listenImpl();
        this.setListening(true);
    }

    public final void shutdown() throws ModbusIOException {
        this.setListening(false);
        this.shutdownImpl();
    }

    public boolean isListening() {
        return this.listening.get();
    }

    protected void setListening(boolean listening) {
        this.listening.set(listening);
    }

    public DataHolder getDataHolder() {
        return this.dataHolder;
    }

    public void setDataHolder(DataHolderBuilder builder) {
        this.setDataHolder(builder.build());
    }

    public void setDataHolder(DataHolder dataHolder) {
        this.dataHolder = dataHolder;
    }

    public int getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(int serverAddress) {
        if (Modbus.checkServerAddress(serverAddress)) {
            this.serverAddress = serverAddress;
        }
    }

    public boolean isBroadcastEnabled() {
        return this.broadcastEnabled.get();
    }

    public void setBroadcastEnabled(boolean broadcastEnabled) {
        this.broadcastEnabled.set(broadcastEnabled);
    }

    protected List<ModbusConnection> getConnectionList() {
        return this.connectionList;
    }

    void connectionOpened(ModbusConnection connection) {
        connection.setReadTimeout(this.getReadTimeout());
        this.getConnectionList().add(connection);
    }

    void connectionClosed(ModbusConnection connection) {
        this.getConnectionList().remove(connection);
    }

    @Override
    public void addListener(FrameEventListener listener) {
        for (ModbusConnection c : this.getConnectionList()) {
            c.addListener(listener);
        }
    }

    @Override
    public void removeListener(FrameEventListener listener) {
        for (ModbusConnection c : this.getConnectionList()) {
            c.removeListener(listener);
        }
    }

    @Override
    public void removeListeners() {
        for (ModbusConnection c : this.getConnectionList()) {
            c.removeListeners();
        }
    }

    @Override
    public void fireFrameReceivedEvent(FrameEvent event) {
        for (ModbusConnection c : this.getConnectionList()) {
            c.fireFrameReceivedEvent(event);
        }
    }

    @Override
    public void fireFrameSentEvent(FrameEvent event) {
        for (ModbusConnection c : this.getConnectionList()) {
            c.fireFrameSentEvent(event);
        }
    }

    @Override
    public int countListeners() {
        int count = 0;
        for (ModbusConnection c : this.getConnectionList()) {
            count += c.countListeners();
        }
        return count;
    }

    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observable.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.observable.deleteObservers();
    }

    public int countObservers() {
        return this.observable.countObservers();
    }

    protected void notifyObservers(Object o) {
        this.observable.notifyObservers(o);
    }
}

