/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.serial;

import com.intelligt.modbus.jlibmodbus.serial.SerialParameters;
import com.intelligt.modbus.jlibmodbus.serial.SerialPort;
import com.intelligt.modbus.jlibmodbus.serial.SerialPortException;
import java.io.IOException;

public class SerialPortJSSC
extends SerialPort {
    private final jssc.SerialPort port;

    public SerialPortJSSC(SerialParameters sp) {
        super(sp);
        this.port = new jssc.SerialPort(sp.getDevice());
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.port.writeByte((byte)b);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        try {
            this.port.writeBytes(bytes);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void open() throws SerialPortException {
        try {
            this.port.openPort();
            SerialParameters sp = this.getSerialParameters();
            this.port.setParams(sp.getBaudRate(), sp.getDataBits(), sp.getStopBits(), sp.getParity().getValue());
            this.port.setFlowControlMode(0);
        }
        catch (Exception ex) {
            throw new SerialPortException(ex);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.getReadTimeout() > 0) {
                return this.port.readBytes(1, this.getReadTimeout())[0];
            }
            return this.port.readBytes(1)[0];
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            byte[] rb = this.port.readBytes(len, this.getReadTimeout());
            System.arraycopy(rb, 0, b, off, len);
            return rb.length;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() {
        if (this.isOpened()) {
            try {
                this.port.closePort();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isOpened() {
        return this.port.isOpened();
    }
}

