/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.serial;

import com.google.android.things.pio.PeripheralManager;
import com.google.android.things.pio.UartDevice;
import com.intelligt.modbus.jlibmodbus.serial.SerialParameters;
import com.intelligt.modbus.jlibmodbus.serial.SerialPort;
import com.intelligt.modbus.jlibmodbus.serial.SerialPortException;
import java.io.IOException;

public class SerialPortAT
extends SerialPort {
    private UartDevice port = null;
    byte[] buffer = new byte[254];
    volatile long readTime = 0L;

    public SerialPortAT(SerialParameters sp) {
        super(sp);
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.port.write(new byte[]{(byte)(b & 0xFF)}, 1);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        try {
            this.port.write(bytes, bytes.length);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void open() throws SerialPortException {
        try {
            SerialParameters sp = this.getSerialParameters();
            this.port = PeripheralManager.getInstance().openUartDevice(sp.getDevice());
            this.port.setBaudrate(sp.getBaudRate());
            this.port.setDataSize(sp.getDataBits());
            this.port.setParity(sp.getParity().getValue());
            this.port.setStopBits(sp.getStopBits());
            this.port.setHardwareFlowControl(0);
        }
        catch (Exception ex) {
            throw new SerialPortException(ex);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            this.readTime = System.currentTimeMillis();
            while (this.port.read(this.buffer, 1) < 1) {
                if (System.currentTimeMillis() - this.readTime <= (long)this.getReadTimeout()) continue;
                throw new IOException("Read timeout");
            }
            return this.buffer[0];
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            this.readTime = System.currentTimeMillis();
            int count = 0;
            while (count < len) {
                int read = this.port.read(this.buffer, this.buffer.length);
                if ((count += read) > len) {
                    int diff = count - len;
                    read -= diff;
                    count -= diff;
                }
                System.arraycopy(this.buffer, 0, b, off, read);
                off += read;
                if (System.currentTimeMillis() - this.readTime <= (long)this.getReadTimeout()) continue;
                throw new IOException("Read timeout");
            }
            return count;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isOpened()) {
            try {
                SerialPortAT serialPortAT = this;
                synchronized (serialPortAT) {
                    this.port.close();
                    this.port = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized boolean isOpened() {
        return this.port != null;
    }
}

