/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.net.stream.base;

import com.intelligt.modbus.jlibmodbus.utils.ByteFifo;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ModbusOutputStream
extends OutputStream {
    private final ByteFifo fifo = new ByteFifo(256);

    @Override
    public void write(byte[] b) throws IOException {
        this.fifo.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.fifo.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.fifo.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.fifo.reset();
    }

    public void writeShortBE(int s) throws IOException {
        this.write(DataUtils.byteHigh(s));
        this.write(DataUtils.byteLow(s));
    }

    public void writeShortLE(int s) throws IOException {
        this.write(DataUtils.byteLow(s));
        this.write(DataUtils.byteHigh(s));
    }

    public byte[] toByteArray() {
        return this.fifo.toByteArray();
    }

    public ByteFifo getFifo() {
        return this.fifo;
    }
}

