/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.net.stream;

import com.intelligt.modbus.jlibmodbus.exception.ModbusChecksumException;
import com.intelligt.modbus.jlibmodbus.net.stream.InputStreamSerial;
import com.intelligt.modbus.jlibmodbus.serial.SerialPort;
import com.intelligt.modbus.jlibmodbus.utils.CRC16;
import java.io.IOException;

public class InputStreamRTU
extends InputStreamSerial {
    private int crc = 65535;

    public InputStreamRTU(SerialPort serial) {
        super(serial);
    }

    @Override
    public void frameCheck() throws IOException, ModbusChecksumException {
        int r_crc;
        int c_crc = this.getCrc();
        if (c_crc != (r_crc = this.readShortLE())) {
            throw new ModbusChecksumException(r_crc, c_crc);
        }
    }

    @Override
    public void frameInit() {
        this.crc = 65535;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        this.crc = CRC16.calc(this.crc, (byte)b);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int c = super.read(b, off, len);
        this.crc = CRC16.calc(this.crc, b, off, len);
        return c;
    }

    private int getCrc() {
        return this.crc;
    }
}

