/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.net;

import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.net.ModbusConnection;
import com.intelligt.modbus.jlibmodbus.net.stream.base.LoggingInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.LoggingOutputStream;
import com.intelligt.modbus.jlibmodbus.net.transport.ModbusTransport;
import com.intelligt.modbus.jlibmodbus.net.transport.ModbusTransportFactory;
import com.intelligt.modbus.jlibmodbus.tcp.TcpParameters;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

class ModbusMasterConnectionTCP
extends ModbusConnection {
    private final TcpParameters parameters;
    private ModbusTransport transport = null;

    ModbusMasterConnectionTCP(TcpParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public LoggingOutputStream getOutputStream() {
        return this.transport.getOutputStream();
    }

    @Override
    public LoggingInputStream getInputStream() {
        return this.transport.getInputStream();
    }

    @Override
    public ModbusTransport getTransport() {
        return this.transport;
    }

    @Override
    protected void openImpl() throws ModbusIOException {
        if (!this.isOpened()) {
            if (this.parameters != null) {
                Socket socket = new Socket();
                InetSocketAddress isa = new InetSocketAddress(this.parameters.getHost(), this.parameters.getPort());
                try {
                    socket.connect(isa, 3000);
                    socket.setKeepAlive(this.parameters.isKeepAlive());
                    this.transport = ModbusTransportFactory.createTCP(socket);
                    this.setReadTimeout(this.getReadTimeout());
                }
                catch (Exception e) {
                    throw new ModbusIOException(e);
                }
            } else {
                throw new ModbusIOException("TCP parameters is null");
            }
        }
    }

    @Override
    protected void closeImpl() throws ModbusIOException {
        try {
            if (this.transport != null) {
                this.transport.close();
            }
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
        finally {
            this.transport = null;
        }
    }
}

