/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.net;

import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.net.stream.base.LoggingInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.LoggingOutputStream;
import com.intelligt.modbus.jlibmodbus.net.transport.ModbusTransport;
import com.intelligt.modbus.jlibmodbus.utils.FrameEventListenerListImpl;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ModbusConnection
extends FrameEventListenerListImpl {
    private int readTimeout = 1000;
    private final AtomicBoolean opened = new AtomicBoolean(false);

    public abstract LoggingOutputStream getOutputStream();

    public abstract LoggingInputStream getInputStream();

    public abstract ModbusTransport getTransport();

    public final void open() throws ModbusIOException {
        this.openImpl();
        this.setOpened(true);
        this.getOutputStream().setListenerList(this);
        this.getInputStream().setListenerList(this);
    }

    public final void close() throws ModbusIOException {
        try {
            this.closeImpl();
        }
        finally {
            this.setOpened(false);
        }
    }

    protected abstract void openImpl() throws ModbusIOException;

    protected abstract void closeImpl() throws ModbusIOException;

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int timeout) {
        LoggingInputStream is;
        this.readTimeout = timeout;
        if (this.getTransport() != null && (is = this.getInputStream()) != null) {
            is.setReadTimeout(timeout);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public boolean isOpened() {
        return this.opened.get();
    }

    private void setOpened(boolean opened) {
        this.opened.set(opened);
    }
}

