/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.response;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.ModbusCoils;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractReadResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;
import java.util.Arrays;

public class ReadCoilsResponse
extends AbstractReadResponse {
    private byte[] buffer = new byte[0];

    public static int calcByteCount(boolean[] coils) {
        return ReadCoilsResponse.calcByteCount(coils.length);
    }

    public static int calcByteCount(int coilCount) {
        return (int)Math.ceil((double)coilCount / 8.0);
    }

    public final byte[] getBytes() {
        return Arrays.copyOf(this.buffer, this.buffer.length);
    }

    @Deprecated
    public final boolean[] getCoils() {
        return DataUtils.toBitsArray(this.buffer, this.buffer.length * 8);
    }

    public final ModbusCoils getModbusCoils() {
        return new ModbusCoils(this.buffer);
    }

    public final void setCoils(boolean[] coils) throws ModbusNumberException {
        this.buffer = DataUtils.toByteArray(coils);
        this.setByteCount(ReadCoilsResponse.calcByteCount(coils));
    }

    @Override
    protected final void readData(ModbusInputStream fifo) throws IOException {
        this.buffer = new byte[this.getByteCount()];
        int size = fifo.read(this.buffer);
        if (size < this.buffer.length) {
            Modbus.log().warning(this.buffer.length + " bytes expected, but " + size + " received.");
        }
    }

    @Override
    protected final void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.buffer);
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_COILS.toInt();
    }
}

