/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadExceptionStatusResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class ReadExceptionStatusRequest
extends ModbusRequest {
    @Override
    protected Class getResponseClass() {
        return ReadExceptionStatusResponse.class;
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
    }

    @Override
    public int requestSize() {
        return 0;
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadExceptionStatusResponse response = (ReadExceptionStatusResponse)this.getResponse();
        try {
            int exceptionStatus = dataHolder.readExceptionStatus();
            response.setExceptionStatus(exceptionStatus);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        return true;
    }

    @Override
    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_EXCEPTION_STATUS.toInt();
    }
}

