/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadCoilsRequest;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadCoilsResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadDiscreteInputsResponse;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;

public final class ReadDiscreteInputsRequest
extends ReadCoilsRequest {
    @Override
    protected Class getResponseClass() {
        return ReadDiscreteInputsResponse.class;
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadDiscreteInputsResponse response = (ReadDiscreteInputsResponse)this.getResponse();
        try {
            boolean[] range = dataHolder.readDiscreteInputRange(this.getStartAddress(), this.getQuantity());
            response.setCoils(range);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_DISCRETE_INPUTS.toInt();
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadDiscreteInputsResponse)) {
            return false;
        }
        ReadDiscreteInputsResponse r = (ReadDiscreteInputsResponse)response;
        return r.getByteCount() == ReadCoilsResponse.calcByteCount(this.getQuantity());
    }
}

