/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractMultipleRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadCoilsResponse;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;

public class ReadCoilsRequest
extends AbstractMultipleRequest {
    @Override
    protected Class getResponseClass() {
        return ReadCoilsResponse.class;
    }

    @Override
    public final boolean checkAddressRange(int startAddress, int quantity) {
        return Modbus.checkReadCoilCount(quantity) && Modbus.checkStartAddress(startAddress) && Modbus.checkEndAddress(startAddress + (int)Math.ceil((double)quantity / 16.0));
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.READ_COILS.toInt();
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadCoilsResponse response = (ReadCoilsResponse)this.getResponse();
        try {
            boolean[] range = dataHolder.readCoilRange(this.getStartAddress(), this.getQuantity());
            response.setCoils(range);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadCoilsResponse)) {
            return false;
        }
        ReadCoilsResponse r = (ReadCoilsResponse)response;
        return r.getByteCount() == ReadCoilsResponse.calcByteCount(this.getQuantity());
    }
}

