/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.IllegalFunctionResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public class IllegalFunctionRequest
extends ModbusRequest {
    private final int functionCode;

    public IllegalFunctionRequest(int functionCode) {
        this.functionCode = functionCode;
    }

    @Override
    protected Class getResponseClass() {
        return IllegalFunctionResponse.class;
    }

    @Override
    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        throw new IOException("Can't send Illegal request");
    }

    @Override
    public int requestSize() {
        return 0;
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        IllegalFunctionResponse response = (IllegalFunctionResponse)this.getResponse();
        response.setFunctionCode(this.getFunction());
        return response;
    }

    @Override
    protected boolean validateResponseImpl(ModbusResponse response) {
        return response.getFunction() == this.getFunction();
    }

    @Override
    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
    }

    @Override
    public int getFunction() {
        return this.functionCode;
    }
}

