/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.base;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractMultipleRequest;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public abstract class AbstractWriteMultipleRequest
extends AbstractMultipleRequest {
    private byte[] values;
    private int byteCount;

    protected AbstractWriteMultipleRequest() {
    }

    @Override
    public void writeData(ModbusOutputStream fifo) throws IOException {
        super.writeData(fifo);
        fifo.write(this.getByteCount());
        fifo.write(this.getBytes());
    }

    @Override
    protected void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        super.readData(fifo);
        this.setByteCount(fifo.read());
        this.values = new byte[this.byteCount];
        int size = fifo.read(this.values, 0, this.getByteCount());
        if (size < this.getByteCount()) {
            Modbus.log().warning(this.getByteCount() + " bytes expected, but " + size + " received.");
        }
    }

    public int getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(int byteCount) throws ModbusNumberException {
        if (byteCount > 246) {
            throw new ModbusNumberException("" + byteCount);
        }
        this.byteCount = byteCount;
    }

    public byte[] getBytes() {
        return this.values;
    }

    public void setBytes(byte[] values) throws ModbusNumberException {
        this.values = values;
        this.setByteCount(values.length);
    }

    @Override
    protected int dataSize() {
        return super.dataSize() + 1 + this.getByteCount();
    }
}

