/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.base;

import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import java.io.IOException;

public abstract class AbstractReadResponse
extends ModbusResponse {
    private int byteCount = 0;

    protected AbstractReadResponse() {
    }

    public int getByteCount() {
        return this.byteCount;
    }

    protected void setByteCount(int byteCount) throws ModbusNumberException {
        if (byteCount > 252) {
            throw new ModbusNumberException("Byte count greater than max allowable");
        }
        this.byteCount = byteCount;
    }

    @Override
    public final void readResponse(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        this.setByteCount(fifo.read());
        this.readData(fifo);
    }

    @Override
    public final void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.getByteCount());
        this.writeData(fifo);
    }

    protected abstract void readData(ModbusInputStream var1) throws IOException, ModbusNumberException;

    protected abstract void writeData(ModbusOutputStream var1) throws IOException;

    @Override
    protected final int responseSize() {
        return 1 + this.getByteCount();
    }
}

