/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg;

import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractDataRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractMultipleRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusFileRecord;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.mei.ReadDeviceIdentificationCode;
import com.intelligt.modbus.jlibmodbus.msg.request.DiagnosticsRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.GetCommEventCounterRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.GetCommEventLogRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.MaskWriteRegisterRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadCoilsRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadDeviceIdentificationRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadDiscreteInputsRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadExceptionStatusRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadFifoQueueRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadFileRecordRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadHoldingRegistersRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadInputRegistersRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReadWriteMultipleRegistersRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.ReportSlaveIdRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteFileRecordRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteMultipleCoilsRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteMultipleRegistersRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteSingleCoilRequest;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteSingleRegisterRequest;
import com.intelligt.modbus.jlibmodbus.utils.DiagnosticsSubFunctionCode;
import java.util.Arrays;

public class ModbusRequestBuilder {
    public static ModbusRequestBuilder getInstance() {
        return SingletonHolder.instance;
    }

    private ModbusRequest setBaseParameter(ModbusRequest request, int serverAddress) throws ModbusNumberException {
        request.setServerAddress(serverAddress);
        return request;
    }

    private void setSimpleDataRequestParameters(AbstractDataRequest request, int serverAddress, int startAddress) throws ModbusNumberException {
        request.setServerAddress(serverAddress);
        request.setStartAddress(startAddress);
    }

    private void setMultipleDataRequestParameters(AbstractMultipleRequest request, int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        this.setSimpleDataRequestParameters(request, serverAddress, startAddress);
        request.setQuantity(quantity);
    }

    public ModbusRequest buildReadCoils(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        ReadCoilsRequest request = new ReadCoilsRequest();
        this.setMultipleDataRequestParameters(request, serverAddress, startAddress, quantity);
        return request;
    }

    public ModbusRequest buildReadDiscreteInputs(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        ReadDiscreteInputsRequest request = new ReadDiscreteInputsRequest();
        this.setMultipleDataRequestParameters(request, serverAddress, startAddress, quantity);
        return request;
    }

    public ModbusRequest buildReadInputRegisters(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        ReadInputRegistersRequest request = new ReadInputRegistersRequest();
        this.setMultipleDataRequestParameters(request, serverAddress, startAddress, quantity);
        return request;
    }

    public ModbusRequest buildReadHoldingRegisters(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        ReadHoldingRegistersRequest request = new ReadHoldingRegistersRequest();
        this.setMultipleDataRequestParameters(request, serverAddress, startAddress, quantity);
        return request;
    }

    public ModbusRequest buildReadWriteMultipleRegisters(int serverAddress, int readAddress, int readQuantity, int writeAddress, int[] registers) throws ModbusNumberException {
        ReadWriteMultipleRegistersRequest request = new ReadWriteMultipleRegistersRequest();
        request.setServerAddress(serverAddress);
        request.setReadAddress(readAddress);
        request.setReadQuantity(readQuantity);
        request.setWriteAddress(writeAddress);
        request.setWriteRegisters(registers);
        return request;
    }

    public ModbusRequest buildWriteSingleCoil(int serverAddress, int startAddress, boolean coil) throws ModbusNumberException {
        WriteSingleCoilRequest request = new WriteSingleCoilRequest();
        this.setSimpleDataRequestParameters(request, serverAddress, startAddress);
        request.setCoil(coil);
        return request;
    }

    public ModbusRequest buildWriteMultipleCoils(int serverAddress, int startAddress, boolean[] coils) throws ModbusNumberException {
        WriteMultipleCoilsRequest request = new WriteMultipleCoilsRequest();
        this.setSimpleDataRequestParameters(request, serverAddress, startAddress);
        request.setCoils(coils);
        return request;
    }

    public ModbusRequest buildWriteMultipleRegisters(int serverAddress, int startAddress, int[] registers) throws ModbusNumberException {
        WriteMultipleRegistersRequest request = new WriteMultipleRegistersRequest();
        this.setSimpleDataRequestParameters(request, serverAddress, startAddress);
        request.setRegisters(registers);
        return request;
    }

    public ModbusRequest buildWriteMultipleRegisters(int serverAddress, int startAddress, byte[] bytes) throws ModbusNumberException {
        WriteMultipleRegistersRequest request = new WriteMultipleRegistersRequest();
        this.setSimpleDataRequestParameters(request, serverAddress, startAddress);
        request.setBytes(bytes);
        return request;
    }

    public ModbusRequest buildWriteSingleRegister(int serverAddress, int startAddress, int register) throws ModbusNumberException {
        WriteSingleRegisterRequest request = new WriteSingleRegisterRequest();
        this.setSimpleDataRequestParameters(request, serverAddress, startAddress);
        request.setValue(register);
        return request;
    }

    public ModbusRequest buildMaskWriteRegister(int serverAddress, int startAddress, int and, int or) throws ModbusNumberException {
        MaskWriteRegisterRequest request = new MaskWriteRegisterRequest();
        this.setSimpleDataRequestParameters(request, serverAddress, startAddress);
        request.setMaskAnd(and);
        request.setMaskOr(or);
        return request;
    }

    public ModbusRequest buildReadExceptionStatus(int serverAddress) throws ModbusNumberException {
        return this.setBaseParameter(new ReadExceptionStatusRequest(), serverAddress);
    }

    public ModbusRequest buildReportSlaveId(int serverAddress) throws ModbusNumberException {
        return this.setBaseParameter(new ReportSlaveIdRequest(), serverAddress);
    }

    public ModbusRequest buildGetCommEventCounter(int serverAddress) throws ModbusNumberException {
        return this.setBaseParameter(new GetCommEventCounterRequest(), serverAddress);
    }

    public ModbusRequest buildGetCommEventLog(int serverAddress) throws ModbusNumberException {
        return this.setBaseParameter(new GetCommEventLogRequest(), serverAddress);
    }

    public ModbusRequest buildReadFifoQueue(int serverAddress, int fifoPointerAddress) throws ModbusNumberException {
        ReadFifoQueueRequest request = new ReadFifoQueueRequest();
        request.setServerAddress(serverAddress);
        request.setStartAddress(fifoPointerAddress);
        return request;
    }

    public ModbusRequest buildReadFileRecord(int serverAddress, ModbusFileRecord[] records) throws ModbusNumberException {
        ReadFileRecordRequest request = new ReadFileRecordRequest();
        request.setServerAddress(serverAddress);
        request.addFileRecords(Arrays.asList(records));
        return request;
    }

    public ModbusRequest buildWriteFileRecord(int serverAddress, ModbusFileRecord record) throws ModbusNumberException {
        WriteFileRecordRequest request = new WriteFileRecordRequest();
        request.setServerAddress(serverAddress);
        request.setFileRecord(record);
        return request;
    }

    public ModbusRequest buildDiagnostics(DiagnosticsSubFunctionCode subFunctionCode, int serverAddress, int data) throws ModbusNumberException {
        DiagnosticsRequest request = new DiagnosticsRequest();
        request.setServerAddress(serverAddress);
        request.setSubFunctionCode(subFunctionCode);
        request.setSubFunctionData(data);
        return request;
    }

    public ModbusRequest buildReturnQueryData(int serverAddress, int queryData) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.RETURN_QUERY_DATA, serverAddress, queryData);
    }

    public ModbusRequest buildRestartCommunicationsOption(int serverAddress, boolean clearLog) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.RESTART_COMMUNICATIONS_OPTION, serverAddress, clearLog ? 65280 : 0);
    }

    public ModbusRequest buildReturnDiagnosticRegister(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.RETURN_DIAGNOSTIC_REGISTER, serverAddress, 0);
    }

    public ModbusRequest buildChangeAsciiInputDelimiter(int serverAddress, int delimiter) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.CHANGE_ASCII_INPUT_DELIMITER, serverAddress, delimiter);
    }

    public ModbusRequest buildForceListenOnlyMode(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.FORCE_LISTEN_ONLY_MODE, serverAddress, 0);
    }

    public ModbusRequest buildClearCountersAndDiagnosticRegister(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.CLEAR_COUNTERS_AND_DIAGNOSTIC_REGISTER, serverAddress, 0);
    }

    public ModbusRequest buildReturnBusMessageCount(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.RETURN_BUS_MESSAGE_COUNT, serverAddress, 0);
    }

    public ModbusRequest buildReturnBusCommunicationErrorCount(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.RETURN_BUS_COMMUNICATION_ERROR_COUNT, serverAddress, 0);
    }

    public ModbusRequest buildReturnBusExceptionErrorCount(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.RETURN_BUS_EXCEPTION_ERROR_COUNT, serverAddress, 0);
    }

    public ModbusRequest buildReturnSlaveMessageCount(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.RETURN_SLAVE_MESSAGE_COUNT, serverAddress, 0);
    }

    public ModbusRequest buildReturnSlaveNoResponseCount(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.RETURN_SLAVE_NO_RESPONSE_COUNT, serverAddress, 0);
    }

    public ModbusRequest buildReturnSlaveNAKCount(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.RETURN_SLAVE_NAK_COUNT, serverAddress, 0);
    }

    public ModbusRequest buildReturnSlaveBusyCount(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.RETURN_SLAVE_BUSY_COUNT, serverAddress, 0);
    }

    public ModbusRequest buildReturnBusCharacterOverrunCount(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.RETURN_BUS_CHARACTER_OVERRUN_COUNT, serverAddress, 0);
    }

    public ModbusRequest buildClearOverrunCounterAndFlag(int serverAddress) throws ModbusNumberException {
        return this.buildDiagnostics(DiagnosticsSubFunctionCode.CLEAR_OVERRUN_COUNTER_AND_FLAG, serverAddress, 0);
    }

    public ModbusRequest buildReadDeviceIdentification(int serverAddress, int objectId, ReadDeviceIdentificationCode readDeviceId) throws ModbusNumberException {
        ReadDeviceIdentificationRequest request = new ReadDeviceIdentificationRequest();
        request.setServerAddress(serverAddress);
        request.setObjectId(objectId);
        request.setReadDeviceId(readDeviceId);
        return request;
    }

    private static class SingletonHolder {
        private static final ModbusRequestBuilder instance = new ModbusRequestBuilder();

        private SingletonHolder() {
        }
    }
}

