/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.data;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.data.DataHolderBuilder;
import com.intelligt.modbus.jlibmodbus.data.ModbusCoils;
import com.intelligt.modbus.jlibmodbus.data.ModbusHoldingRegisters;
import com.intelligt.modbus.jlibmodbus.data.SimpleExceptionStatus;
import com.intelligt.modbus.jlibmodbus.data.SimpleFifoQueue;
import com.intelligt.modbus.jlibmodbus.data.SimpleSlaveId;
import com.intelligt.modbus.jlibmodbus.data.mei.ReadDeviceIdentificationInterface;
import com.intelligt.modbus.jlibmodbus.exception.IllegalDataAddressException;

public class SimpleDataHolderBuilder
extends DataHolderBuilder {
    private final int coilCount;
    private final int discreteInputCount;
    private final int holdingRegisterCount;
    private final int inputRegisterCount;
    private final int slaveIdSize;

    public SimpleDataHolderBuilder(int size) {
        this.inputRegisterCount = this.slaveIdSize = size;
        this.holdingRegisterCount = this.slaveIdSize;
        this.discreteInputCount = this.slaveIdSize;
        this.coilCount = this.slaveIdSize;
    }

    public SimpleDataHolderBuilder(int slaveIdSize, int inputRegisterCount, int holdingRegisterCount, int discreteInputCount, int coilCount) {
        this.slaveIdSize = slaveIdSize;
        this.inputRegisterCount = inputRegisterCount;
        this.holdingRegisterCount = holdingRegisterCount;
        this.discreteInputCount = discreteInputCount;
        this.coilCount = coilCount;
    }

    @Override
    public DataHolder getDataHolder() {
        return this.dataHolder;
    }

    @Override
    public void buildCoils() {
        this.dataHolder.setCoils(new ModbusCoils(this.coilCount));
    }

    @Override
    public void buildDiscreteInputs() {
        this.dataHolder.setDiscreteInputs(new ModbusCoils(this.discreteInputCount));
    }

    @Override
    public void buildHoldingRegisters() {
        this.dataHolder.setHoldingRegisters(new ModbusHoldingRegisters(this.holdingRegisterCount));
    }

    @Override
    public void buildInputRegisters() {
        this.dataHolder.setInputRegisters(new ModbusHoldingRegisters(this.inputRegisterCount));
    }

    @Override
    public void buildSlaveId() {
        this.dataHolder.setSlaveId(new SimpleSlaveId(this.slaveIdSize));
    }

    @Override
    public void buildExceptionStatus() {
        this.dataHolder.setExceptionStatus(new SimpleExceptionStatus(0));
    }

    @Override
    public void buildFifoQueue() {
        try {
            this.dataHolder.addFifoQueue(new SimpleFifoQueue(), 0);
        }
        catch (IllegalDataAddressException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readDeviceIdentificationInterface() {
        this.dataHolder.setReadDeviceIdentificationInterface(new ReadDeviceIdentificationInterface());
    }
}

