/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.data;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.comm.ModbusCommEvent;
import java.util.LinkedList;
import java.util.List;

public class CommStatus {
    public static final int EVENT_QUEUE_CAPACITY = 246;
    private boolean listenOnlyMode = false;
    private volatile boolean restartCommunicationsOption = false;
    private volatile boolean clearLog = false;
    private int diagnosticRegister = 0;
    private int commStatus = 0;
    private int eventCount = 0;
    private int busMessageCount = 0;
    private int slaveMessageCount = 0;
    private int communicationErrorCount = 0;
    private int exceptionErrorCount = 0;
    private int slaveNoResponseCount = 0;
    private int slaveNAKCount = 0;
    private int slaveBusyCount = 0;
    private int characterOverrunCount = 0;
    private final LinkedList<ModbusCommEvent> eventQueue = new LinkedList();

    public void enter() {
        this.commStatus = 65535;
    }

    public void leave() {
        this.commStatus = 0;
    }

    public void incEventCounter() {
        ++this.eventCount;
    }

    public void incBusMessageCounter() {
        ++this.busMessageCount;
    }

    public void incSlaveMessageCounter() {
        ++this.slaveMessageCount;
    }

    public void incCommErrorCounter() {
        ++this.communicationErrorCount;
    }

    public void incExErrorCounter() {
        ++this.exceptionErrorCount;
    }

    public void incNoResponseCounter() {
        ++this.exceptionErrorCount;
    }

    public void incSlaveNAKCounter() {
        ++this.exceptionErrorCount;
    }

    public void incSlaveBusyCounter() {
        ++this.exceptionErrorCount;
    }

    public void incCharacterOverrunCounter() {
        ++this.exceptionErrorCount;
    }

    public int getCommStatus() {
        return this.commStatus;
    }

    public void setCommStatus(int commStatus) {
        this.commStatus = commStatus;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    public int getMessageCount() {
        return this.busMessageCount;
    }

    public void setBusMessageCount(int busMessageCount) {
        this.busMessageCount = busMessageCount;
    }

    public int getSlaveMessageCount() {
        return this.slaveMessageCount;
    }

    public void setSlaveMessageCount(int slaveMessageCount) {
        this.slaveMessageCount = slaveMessageCount;
    }

    public int getCommunicationErrorCount() {
        return this.communicationErrorCount;
    }

    public void setCommunicationErrorCount(int communicationErrorCount) {
        this.communicationErrorCount = communicationErrorCount;
    }

    public int getExceptionErrorCount() {
        return this.exceptionErrorCount;
    }

    public void setExceptionErrorCount(int exceptionErrorCount) {
        this.exceptionErrorCount = exceptionErrorCount;
    }

    public int getSlaveNoResponseCount() {
        return this.slaveNoResponseCount;
    }

    public void setSlaveNoResponseCount(int slaveNoResponseCount) {
        this.slaveNoResponseCount = slaveNoResponseCount;
    }

    public int getSlaveNAKCount() {
        return this.slaveNAKCount;
    }

    public void setSlaveNAKCount(int slaveNAKCount) {
        this.slaveNAKCount = slaveNAKCount;
    }

    public int getSlaveBusyCount() {
        return this.slaveBusyCount;
    }

    public void setSlaveBusyCount(int slaveBusyCount) {
        this.slaveBusyCount = slaveBusyCount;
    }

    public int getCharacterOverrunCount() {
        return this.characterOverrunCount;
    }

    public void setCharacterOverrunCount(int characterOverrunCount) {
        this.characterOverrunCount = characterOverrunCount;
    }

    public int getDiagnosticRegister() {
        return this.diagnosticRegister;
    }

    public void setDiagnosticRegister(int diagnosticRegister) {
        this.diagnosticRegister = diagnosticRegister;
    }

    public void setAsciiInputDelimiter(int asciiInputDelimiter) {
        Modbus.setAsciiInputDelimiter(asciiInputDelimiter);
    }

    public boolean isListenOnlyMode() {
        return this.listenOnlyMode;
    }

    public void setListenOnlyMode(boolean listenOnlyMode) {
        this.listenOnlyMode = listenOnlyMode;
    }

    public boolean isRestartCommunicationsOption() {
        return this.restartCommunicationsOption;
    }

    public void setRestartCommunicationsOption(boolean restartCommunications) {
        this.restartCommunicationsOption = restartCommunications;
    }

    public boolean isClearLog() {
        return this.clearLog;
    }

    public void setClearLog(boolean clearLog) {
        this.clearLog = clearLog;
    }

    public void clearCountersAndDiagnosticRegister() {
        this.setBusMessageCount(0);
        this.setEventCount(0);
        this.setCharacterOverrunCount(0);
        this.setCommunicationErrorCount(0);
        this.setExceptionErrorCount(0);
        this.setSlaveNoResponseCount(0);
        this.setSlaveBusyCount(0);
        this.setSlaveMessageCount(0);
        this.setSlaveNAKCount(0);
    }

    public void restartCommunicationsOption() {
        this.clearCountersAndDiagnosticRegister();
        this.setListenOnlyMode(false);
        if (this.isClearLog()) {
            this.getEventLog().clear();
            this.setClearLog(false);
        }
    }

    public List<ModbusCommEvent> getEventLog() {
        return this.eventQueue;
    }

    public void setEventQueue(List<ModbusCommEvent> eventQueue) {
        this.eventQueue.clear();
        this.eventQueue.addAll(eventQueue);
    }

    public void addEvent(ModbusCommEvent event) {
        if (this.eventQueue.size() >= 246) {
            this.eventQueue.poll();
        }
        this.eventQueue.add(event);
    }
}

