/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.query;

import com.google.common.base.Preconditions;
import com.plotsquared.core.plot.Plot;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PaginatedPlotResult {
    private final List<Plot> plots;
    private final int pageSize;

    PaginatedPlotResult(@NonNull List<Plot> plots, int pageSize) {
        this.plots = plots;
        this.pageSize = pageSize;
    }

    public List<Plot> getPage(int page) {
        Preconditions.checkState((page >= 0 ? 1 : 0) != 0, (Object)"Page must be positive");
        int from = (page - 1) * this.pageSize;
        if (this.plots.size() < from) {
            return Collections.emptyList();
        }
        int to = Math.max(from + this.pageSize, this.plots.size());
        return this.plots.subList(from, to);
    }

    public int getPages() {
        return (int)Math.ceil((double)this.plots.size() / (double)this.pageSize);
    }
}

