/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.placeholders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.placeholders.Placeholder;
import com.plotsquared.core.util.placeholders.PlotFlagPlaceholder;
import com.plotsquared.core.util.placeholders.PlotSpecificPlaceholder;
import com.plotsquared.core.util.query.PlotQuery;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public final class PlaceholderRegistry {
    private final Map<String, Placeholder> placeholders = Maps.newHashMap();
    private final EventDispatcher eventDispatcher;

    @Inject
    public PlaceholderRegistry(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
        this.registerDefault();
    }

    private static String legacyComponent(TranslatableCaption caption, LocaleHolder localeHolder) {
        return PlotSquared.platform().toLegacyPlatformString(caption.toComponent(localeHolder).asComponent());
    }

    private void registerDefault() {
        GlobalFlagContainer globalFlagContainer = GlobalFlagContainer.getInstance();
        for (PlotFlag<?, ?> flag2 : globalFlagContainer.getRecognizedPlotFlags()) {
            this.registerPlaceholder(new PlotFlagPlaceholder(flag2, true));
            this.registerPlaceholder(new PlotFlagPlaceholder(flag2, false));
        }
        GlobalFlagContainer.getInstance().subscribe((flag, type) -> {
            this.registerPlaceholder(new PlotFlagPlaceholder(flag, true));
            this.registerPlaceholder(new PlotFlagPlaceholder(flag, false));
        });
        this.createPlaceholder("world_name", player -> player.getLocation().getWorldName());
        this.createPlaceholder("has_plot", player -> player.getPlotCount() > 0 ? "true" : "false");
        this.createPlaceholder("allowed_plot_count", player -> {
            if (player.getAllowedPlots() >= Integer.MAX_VALUE) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.infinite"), player);
            }
            return Integer.toString(player.getAllowedPlots());
        });
        this.createPlaceholder("base_plot_count", player -> Integer.toString(PlotQuery.newQuery().ownedBy((PlotPlayer<?>)player).whereBasePlot().thatPasses(plot -> !DoneFlag.isDone(plot)).count()));
        this.createPlaceholder("plot_count", player -> Integer.toString(player.getPlotCount()));
        this.createPlaceholder("currentplot_alias", (PlotPlayer<?> player, Plot plot) -> {
            if (plot.getAlias().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), player);
            }
            return plot.getAlias();
        });
        this.createPlaceholder("currentplot_owner", (PlotPlayer<?> player, Plot plot) -> {
            if (((Boolean)plot.getFlag(ServerPlotFlag.class)).booleanValue()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.server"), player);
            }
            UUID plotOwner = plot.getOwnerAbs();
            if (plotOwner == null) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("generic.generic_unowned"), player);
            }
            try {
                return PlotSquared.platform().playerManager().getUsernameCaption(plotOwner).get(Settings.UUID.BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS).getComponent((LocaleHolder)player);
            }
            catch (Exception exception) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.unknown"), player);
            }
        });
        this.createPlaceholder("currentplot_members", (PlotPlayer<?> player, Plot plot) -> {
            if (plot.getMembers().isEmpty() && plot.getTrusted().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), player);
            }
            return String.valueOf(plot.getMembers().size() + plot.getTrusted().size());
        });
        this.createPlaceholder("currentplot_members_added", (PlotPlayer<?> player, Plot plot) -> {
            if (plot.getMembers().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), player);
            }
            return String.valueOf(plot.getMembers().size());
        });
        this.createPlaceholder("currentplot_members_trusted", (PlotPlayer<?> player, Plot plot) -> {
            if (plot.getTrusted().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), player);
            }
            return String.valueOf(plot.getTrusted().size());
        });
        this.createPlaceholder("currentplot_members_denied", (PlotPlayer<?> player, Plot plot) -> {
            if (plot.getDenied().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), player);
            }
            return String.valueOf(plot.getDenied().size());
        });
        this.createPlaceholder("currentplot_members_trusted_list", (PlotPlayer<?> player, Plot plot) -> {
            if (plot.getTrusted().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), player);
            }
            return PlotSquared.platform().toLegacyPlatformString(PlayerManager.getPlayerList(plot.getTrusted(), player));
        });
        this.createPlaceholder("currentplot_members_added_list", (PlotPlayer<?> player, Plot plot) -> {
            if (plot.getMembers().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), player);
            }
            return PlotSquared.platform().toLegacyPlatformString(PlayerManager.getPlayerList(plot.getMembers(), player));
        });
        this.createPlaceholder("currentplot_members_denied_list", (PlotPlayer<?> player, Plot plot) -> {
            if (plot.getDenied().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), player);
            }
            return PlotSquared.platform().toLegacyPlatformString(PlayerManager.getPlayerList(plot.getDenied(), player));
        });
        this.createPlaceholder("currentplot_creationdate", (PlotPlayer<?> player, Plot plot) -> {
            if (plot.getTimestamp() == 0L || !plot.hasOwner()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.unknown"), player);
            }
            long creationDate = plot.getTimestamp();
            SimpleDateFormat sdf = new SimpleDateFormat(Settings.Timeformat.DATE_FORMAT);
            sdf.setTimeZone(TimeZone.getTimeZone(Settings.Timeformat.TIME_ZONE));
            return sdf.format(creationDate);
        });
        this.createPlaceholder("currentplot_can_build", (PlotPlayer<?> player, Plot plot) -> plot.isAdded(player.getUUID()) ? "true" : "false");
        this.createPlaceholder("currentplot_x", (PlotPlayer<?> player, Plot plot) -> Integer.toString(plot.getId().getX()));
        this.createPlaceholder("currentplot_y", (PlotPlayer<?> player, Plot plot) -> Integer.toString(plot.getId().getY()));
        this.createPlaceholder("currentplot_xy", (PlotPlayer<?> player, Plot plot) -> plot.getId().toString());
        this.createPlaceholder("currentplot_rating", (PlotPlayer<?> player, Plot plot) -> {
            if (Double.isNaN(plot.getAverageRating())) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("placeholder.nan"), player);
            }
            BigDecimal roundRating = BigDecimal.valueOf(plot.getAverageRating()).setScale(2, RoundingMode.HALF_UP);
            if (!Settings.General.SCIENTIFIC) {
                return String.valueOf(roundRating);
            }
            return Double.toString(plot.getAverageRating());
        });
        this.createPlaceholder("currentplot_biome", (PlotPlayer<?> player, Plot plot) -> plot.getBiomeSynchronous().toString());
        this.createPlaceholder("currentplot_size", (PlotPlayer<?> player, Plot plot) -> String.valueOf(plot.getConnectedPlots().size()));
        this.createPlaceholder("total_grants", player -> {
            try (MetaDataAccess<Integer> metaDataAccess = player.accessPersistentMetaData(PlayerMetaDataKeys.PERSISTENT_GRANTED_PLOTS);){
                String string = Integer.toString(metaDataAccess.get().orElse(0));
                return string;
            }
        });
    }

    public void createPlaceholder(@NonNull String key, final @NonNull Function<PlotPlayer<?>, String> placeholderFunction) {
        this.registerPlaceholder(new Placeholder(key){

            @Override
            public @NonNull String getValue(@NonNull PlotPlayer<?> player) {
                return (String)placeholderFunction.apply(player);
            }
        });
    }

    public void createPlaceholder(@NonNull String key, final @NonNull BiFunction<PlotPlayer<?>, Plot, String> placeholderFunction) {
        this.registerPlaceholder(new PlotSpecificPlaceholder(key){

            @Override
            public @NonNull String getValue(@NonNull PlotPlayer<?> player, @NonNull Plot plot) {
                return (String)placeholderFunction.apply(player, plot);
            }
        });
    }

    public void registerPlaceholder(@NonNull Placeholder placeholder) {
        Placeholder previous = this.placeholders.put(placeholder.getKey().toLowerCase(Locale.ENGLISH), (Placeholder)Preconditions.checkNotNull((Object)placeholder, (Object)"Placeholder may not be null"));
        if (previous == null) {
            this.eventDispatcher.callGenericEvent(new PlaceholderAddedEvent(placeholder));
        }
    }

    public @Nullable Placeholder getPlaceholder(@NonNull String key) {
        return this.placeholders.get(((String)Preconditions.checkNotNull((Object)key, (Object)"Key may not be null")).toLowerCase(Locale.ENGLISH));
    }

    public @NonNull String getPlaceholderValue(@NonNull String key, @NonNull PlotPlayer<?> player) {
        Placeholder placeholder = this.getPlaceholder(key);
        if (placeholder == null) {
            return "";
        }
        String placeholderValue = "";
        try {
            placeholderValue = placeholder.getValue(player);
            if (placeholderValue == null) {
                new RuntimeException(String.format("Placeholder '%s' returned null for player '%s'", placeholder.getKey(), player.getName())).printStackTrace();
            }
        }
        catch (Exception exception) {
            new RuntimeException(String.format("Placeholder '%s' failed to evalulate for player '%s'", placeholder.getKey(), player.getName()), exception).printStackTrace();
        }
        return placeholderValue;
    }

    public @NonNull Collection<Placeholder> getPlaceholders() {
        return Collections.unmodifiableCollection(this.placeholders.values());
    }

    public record PlaceholderAddedEvent(Placeholder placeholder) {
    }
}

