/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.util.StringMan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;

public class StringComparison<T> {
    private final Function<T, String> toString;
    private T bestMatch;
    private double match = 2.147483647E9;
    private T bestMatchObject;

    public StringComparison(String input, T[] objects) {
        this(input, objects, Object::toString);
    }

    public StringComparison(String input, T[] objects, Function<T, String> toString) {
        this.toString = toString;
        this.init(input, objects);
    }

    public StringComparison(String input, Collection<T> objects) {
        this(input, objects, Object::toString);
    }

    public StringComparison(String input, Collection<T> objects, Function<T, String> toString) {
        this(input, objects.toArray(), toString);
    }

    public StringComparison() {
        this.toString = Object::toString;
    }

    public static int compare(String s1, String s2) {
        int distance = StringMan.getLevenshteinDistance(s1, s2);
        if (s2.contains(s1)) {
            distance -= Math.min(s1.length(), s2.length());
        }
        if (s2.startsWith(s1)) {
            distance -= 4;
        }
        return distance;
    }

    public static ArrayList<String> wLetterPair(String s) {
        String[] wo;
        ArrayList<String> aPairs = new ArrayList<String>();
        for (String aWo : wo = s.split("\\s")) {
            String[] po = StringComparison.sLetterPair(aWo);
            Collections.addAll(aPairs, po);
        }
        return aPairs;
    }

    public static String[] sLetterPair(String s) {
        int numPair = s.length() - 1;
        String[] p = new String[numPair];
        for (int i = 0; i < numPair; ++i) {
            p[i] = s.substring(i, i + 2);
        }
        return p;
    }

    public void init(String input, T[] objects) {
        this.bestMatch = objects[0];
        this.bestMatchObject = objects[0];
        input = input.toLowerCase();
        for (T o : objects) {
            int n;
            int c = StringComparison.compare(input, this.getString(o).toLowerCase());
            if (!((double)n < this.match)) continue;
            this.match = c;
            this.bestMatch = o;
            this.bestMatchObject = o;
        }
    }

    public String getString(T o) {
        return this.toString.apply(o);
    }

    public T getMatchObject() {
        return this.bestMatchObject;
    }

    public String getBestMatch() {
        return this.getString(this.bestMatch);
    }

    public ComparisonResult getBestMatchAdvanced() {
        return new ComparisonResult(this.match, this.bestMatch);
    }

    public class ComparisonResult {
        public final T best;
        public final double match;

        public ComparisonResult(double match, T best) {
            this.match = match;
            this.best = best;
        }
    }
}

