/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import org.checkerframework.checker.nullness.qual.NonNull;

public class EntityUtil {
    private EntityUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static int capNumeral(@NonNull String flagName) {
        return switch (flagName) {
            case "mob-cap" -> 3;
            case "hostile-cap" -> 2;
            case "animal-cap" -> 1;
            case "vehicle-cap" -> 4;
            case "misc-cap" -> 5;
            default -> 0;
        };
    }

    public static boolean checkEntity(Plot plot, PlotFlag<Integer, ?> ... flags) {
        int i;
        if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone(plot)) {
            return true;
        }
        int[] mobs = null;
        for (PlotFlag<Integer, ?> flag : flags) {
            i = EntityUtil.capNumeral(flag.getName());
            int cap = (Integer)plot.getFlag(flag);
            if (cap == Integer.MAX_VALUE) continue;
            if (cap == 0) {
                return true;
            }
            if (mobs == null) {
                mobs = plot.countEntities();
            }
            if (mobs[i] < cap) continue;
            plot.setMeta("EntityCount", mobs);
            plot.setMeta("EntityCountTime", System.currentTimeMillis());
            plot.debug("Prevented spawning of mob because it would exceed " + flag.getName());
            return true;
        }
        if (mobs != null) {
            for (PlotFlag<Integer, ?> flag : flags) {
                int n = i = EntityUtil.capNumeral(flag.getName());
                mobs[n] = mobs[n] + 1;
            }
            plot.setMeta("EntityCount", mobs);
            plot.setMeta("EntityCountTime", System.currentTimeMillis());
        }
        return false;
    }
}

