/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.task.RunnableVal;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.world.World;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ChunkManager {
    private static final Map<BlockVector2, RunnableVal<ZeroedDelegateScopedQueueCoordinator>> forceChunks = new ConcurrentHashMap<BlockVector2, RunnableVal<ZeroedDelegateScopedQueueCoordinator>>();
    private static final Map<BlockVector2, RunnableVal<ZeroedDelegateScopedQueueCoordinator>> addChunks = new ConcurrentHashMap<BlockVector2, RunnableVal<ZeroedDelegateScopedQueueCoordinator>>();

    public static void setChunkInPlotArea(RunnableVal<ZeroedDelegateScopedQueueCoordinator> force, RunnableVal<ZeroedDelegateScopedQueueCoordinator> add, String world, BlockVector2 loc) {
        World weWorld = PlotSquared.platform().worldUtil().getWeWorld(world);
        QueueCoordinator queue = PlotSquared.platform().globalBlockQueue().getNewQueue(weWorld);
        if (PlotSquared.get().getPlotAreaManager().isAugmented(world) && PlotSquared.get().isNonStandardGeneration(world, loc)) {
            int blockX = loc.getX() << 4;
            int blockZ = loc.getZ() << 4;
            ZeroedDelegateScopedQueueCoordinator scoped = new ZeroedDelegateScopedQueueCoordinator(queue, Location.at(world, blockX, weWorld.getMinY(), blockZ), Location.at(world, blockX + 15, weWorld.getMaxY(), blockZ + 15));
            if (force != null) {
                force.run(scoped);
            } else {
                scoped.regenChunk(loc.getX(), loc.getZ());
                if (add != null) {
                    add.run(scoped);
                }
            }
            queue.enqueue();
        } else {
            if (force != null) {
                forceChunks.put(loc, force);
            }
            addChunks.put(loc, add);
            queue.regenChunk(loc.getX(), loc.getZ());
            forceChunks.remove(loc);
            addChunks.remove(loc);
        }
    }

    public static boolean preProcessChunk(BlockVector2 loc, ZeroedDelegateScopedQueueCoordinator queue) {
        RunnableVal<ZeroedDelegateScopedQueueCoordinator> forceChunk = forceChunks.get(loc);
        if (forceChunk != null) {
            forceChunk.run(queue);
            forceChunks.remove(loc);
            return true;
        }
        return false;
    }

    public static boolean postProcessChunk(BlockVector2 loc, ZeroedDelegateScopedQueueCoordinator queue) {
        RunnableVal<ZeroedDelegateScopedQueueCoordinator> addChunk = forceChunks.get(loc);
        if (addChunk != null) {
            addChunk.run(queue);
            addChunks.remove(loc);
            return true;
        }
        return false;
    }

    @Deprecated
    public abstract CompletableFuture<?> loadChunk(String var1, BlockVector2 var2, boolean var3);
}

