/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.synchronization;

import com.google.common.util.concurrent.Striped;
import com.plotsquared.core.synchronization.LockKey;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LockRepository {
    private final Striped<Lock> striped = Striped.lock((int)LockKey.recognizedKeys().size());

    public @NonNull Lock getLock(@NonNull LockKey key) {
        return (Lock)this.striped.get((Object)key);
    }

    public void useLock(@NonNull LockKey key, @NonNull Consumer<Lock> consumer) {
        consumer.accept(this.getLock(key));
    }

    public void useLock(@NonNull LockKey key, @NonNull Runnable runnable) {
        try (LockAccess ignored = this.lock(key);){
            runnable.run();
        }
    }

    public @NonNull LockAccess lock(@NonNull LockKey key) {
        Lock lock = this.getLock(key);
        lock.lock();
        return new LockAccess(lock);
    }

    public static class LockAccess
    implements AutoCloseable {
        private final Lock lock;

        private LockAccess(@NonNull Lock lock) {
            this.lock = lock;
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }
}

