/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.queue.QueueCoordinator;
import com.sk89q.worldedit.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class QueueProvider {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotSquared.class.getSimpleName()));

    public static QueueProvider of(final @NonNull Class<? extends QueueCoordinator> primary) {
        return new QueueProvider(){

            @Override
            public QueueCoordinator getNewQueue(@NonNull World world) {
                try {
                    return (QueueCoordinator)primary.getConstructors()[0].newInstance(world);
                }
                catch (Throwable e) {
                    LOGGER.error("Error creating Queue: {} - Does it have the correct constructor(s)?", (Object)primary.getName());
                    if (!primary.getName().contains("com.plotsquared")) {
                        LOGGER.error("It looks like {} is a custom queue. Please look for a plugin in its classpath and report to them.", (Object)primary.getSimpleName());
                    }
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    public abstract QueueCoordinator getNewQueue(@NonNull World var1);
}

